/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.vctweaker.fuel;

import com.google.common.collect.Lists;
import com.viesis.viescraft.configs.ViesCraftConfig;
import com.viesis.viescraft.init.InitItemsVC;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraftforge.fml.common.registry.GameRegistry;
import se.gory_moon.vctweaker.VCTweaker;

public class FuelHandler {
    private static ArrayList<String> fuels = Lists.newArrayList();

    public static void refreshConfigList(String[] list) {
        fuels.clear();
        for (String s : list) {
            String[] parts = s.split(":");
            String tmp = "";
            if (parts.length < 3) {
                tmp = ":*";
            }
            fuels.add(s + tmp);
        }
    }

    private static boolean containsItem(String location, int meta) {
        return fuels.contains(location + ":" + meta) || fuels.contains(location + ":*");
    }

    private static boolean isItemValid(boolean flag) {
        return VCTweaker.Configs.isWhitelist && !flag || !VCTweaker.Configs.isWhitelist && flag;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        Item item = stack.getItem();
        if ("minecraft".equals(item.getRegistryName().getResourceDomain()) || !VCTweaker.Configs.modedIgnoreList) {
            if (item instanceof ItemBlock && Block.getBlockFromItem((Item)item) != Blocks.AIR) {
                boolean flag;
                Block block = Block.getBlockFromItem((Item)item);
                boolean bl = flag = FuelHandler.containsItem(block.getRegistryName().toString(), stack.getMetadata()) || VCTweaker.Configs.woodMaterial && block.getDefaultState().getMaterial() == Material.WOOD;
                if (FuelHandler.isItemValid(flag)) {
                    return 0;
                }
            } else {
                boolean flag = FuelHandler.containsItem(item.getRegistryName().toString(), stack.getMetadata());
                if (FuelHandler.isItemValid(flag)) {
                    return 0;
                }
            }
        }
        if (ViesCraftConfig.vanillaFuel) {
            int val = item == Item.getItemFromBlock((Block)Blocks.CARPET) ? 670 : (item instanceof ItemBoat ? 4000 : (item == Items.COAL ? 16000 : (item == Items.BLAZE_ROD ? 24000 : (item == Item.getItemFromBlock((Block)Blocks.COAL_BLOCK) ? 160000 : (item == Items.LAVA_BUCKET ? 200000 : 0)))));
            val = item == Items.STICK || item == Items.BOWL || item == Item.getItemFromBlock((Block)Blocks.SAPLING) || item == Item.getItemFromBlock((Block)Blocks.WOODEN_BUTTON) || item == Item.getItemFromBlock((Block)Blocks.WOOL) ? 1000 : val;
            int n = val = item instanceof ItemDoor && item != Items.IRON_DOOR || item == Items.SIGN ? 2000 : val;
            int n2 = item == Item.getItemFromBlock((Block)Blocks.WOODEN_SLAB) ? 1500 : (val = item == Item.getItemFromBlock((Block)Blocks.LADDER) || item == Items.BOW || item == Items.FISHING_ROD || Block.getBlockFromItem((Item)item).getDefaultState().getMaterial() == Material.WOOD ? 3000 : val);
            if (val > 0) {
                return val;
            }
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).getToolMaterialName()) || item instanceof ItemSword && "WOOD".equals(((ItemSword)item).getToolMaterialName()) || item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).getMaterialName())) {
            return 2000;
        }
        return item == InitItemsVC.viesoline_pellets ? ViesCraftConfig.viesolineBurnTime * 20 * 10 : (ViesCraftConfig.outsideModFuel ? GameRegistry.getFuelValue((ItemStack)stack) : 0);
    }
}

