/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.tallgates.items;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import se.gory_moon.tallgates.blocks.BlockRegistry;
import se.gory_moon.tallgates.blocks.BlockTallGate;
import se.gory_moon.tallgates.items.ItemRegistry;

public class ItemTallGate
extends Item
implements ItemRegistry.IMultipleItemModelDefinition {
    private static Block[] GATE_BLOCKS = new Block[]{BlockRegistry.OAK_TALL_GATE, BlockRegistry.SPRUCE_TALL_GATE, BlockRegistry.BIRCH_TALL_GATE, BlockRegistry.JUNGLE_TALL_GATE, BlockRegistry.DARK_OAK_TALL_GATE, BlockRegistry.ACACIA_TALL_GATE};

    public ItemTallGate() {
        this.func_77637_a(CreativeTabs.field_78028_d);
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < GATE_BLOCKS.length; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77960_j() >= GATE_BLOCKS.length) {
            return TextFormatting.RED + "" + TextFormatting.BOLD + "BAD METADATA";
        }
        return super.func_77653_i(stack);
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() >= GATE_BLOCKS.length) {
            return TextFormatting.RED + "" + TextFormatting.BOLD + "BAD METADATA";
        }
        return "item." + GATE_BLOCKS[stack.func_77960_j()].getRegistryName().func_110623_a();
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        for (int i = 0; i < GATE_BLOCKS.length; ++i) {
            models.put(i, new ResourceLocation("tallgates", GATE_BLOCKS[i].getRegistryName().func_110623_a()));
        }
        return models;
    }

    public static Block getBlockFromMeta(int meta) {
        if (meta >= 0 && meta < GATE_BLOCKS.length) {
            return GATE_BLOCKS[meta];
        }
        return GATE_BLOCKS[0];
    }

    public static int getMetaFromBlock(Block block) {
        for (int i = 0; i < GATE_BLOCKS.length; ++i) {
            if (block != GATE_BLOCKS[i]) continue;
            return i;
        }
        return 0;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        IBlockState blockState = worldIn.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        Block gateBlock = ItemTallGate.getBlockFromMeta(player.func_184586_b(hand).func_77960_j());
        if (player.func_175151_a(pos, facing, player.func_184586_b(hand)) && gateBlock.func_176196_c(worldIn, pos)) {
            ItemTallGate.placeGate(worldIn, pos, player.func_174811_aO(), gateBlock);
            SoundType soundtype = gateBlock.func_185467_w();
            worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            player.func_184586_b(hand).func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static void placeGate(World worldIn, BlockPos pos, EnumFacing facing, Block door) {
        BlockPos blockpos = pos.func_177984_a();
        boolean flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos);
        IBlockState iblockstate = door.func_176223_P().func_177226_a((IProperty)BlockTallGate.field_185512_D, (Comparable)facing).func_177226_a((IProperty)BlockTallGate.field_176465_b, (Comparable)Boolean.valueOf(flag)).func_177226_a((IProperty)BlockTallGate.field_176466_a, (Comparable)Boolean.valueOf(flag));
        worldIn.func_180501_a(pos, iblockstate.func_177226_a(BlockTallGate.HALF, (Comparable)((Object)BlockTallGate.EnumGateHalf.LOWER)), 2);
        worldIn.func_180501_a(blockpos, iblockstate.func_177226_a(BlockTallGate.HALF, (Comparable)((Object)BlockTallGate.EnumGateHalf.UPPER)), 2);
        worldIn.func_175685_c(pos, door, false);
        worldIn.func_175685_c(blockpos, door, false);
    }
}

