/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.tallgates.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import se.gory_moon.tallgates.blocks.BlockRegistry;
import se.gory_moon.tallgates.items.ItemRegistry;
import se.gory_moon.tallgates.items.ItemTallGate;

public class BlockTallGate
extends BlockFenceGate
implements BlockRegistry.IStateMappedBlock,
BlockRegistry.ICustomItemBlock {
    public static final PropertyEnum<EnumGateHalf> HALF = PropertyEnum.create((String)"half", EnumGateHalf.class);

    public BlockTallGate(BlockPlanks.EnumType type) {
        super(type);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)OPEN, (Comparable)Boolean.FALSE).withProperty((IProperty)POWERED, (Comparable)Boolean.FALSE).withProperty((IProperty)IN_WALL, (Comparable)Boolean.FALSE).withProperty(HALF, (Comparable)((Object)EnumGateHalf.LOWER)));
        this.setCreativeTab(null);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setSoundType(SoundType.WOOD);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((EnumFacing)(state = this.getActualState(state, source, pos)).getValue((IProperty)FACING)).getAxis() == EnumFacing.Axis.X ? AABB_HITBOX_XAXIS : AABB_HITBOX_ZAXIS;
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.getValue(HALF) == EnumGateHalf.LOWER) {
            IBlockState iblockstate = worldIn.getBlockState(pos.up());
            if (iblockstate.getBlock() == this) {
                state = state.withProperty((IProperty)POWERED, iblockstate.getValue((IProperty)POWERED));
            }
        } else {
            IBlockState iblockstate = worldIn.getBlockState(pos.down());
            if (iblockstate.getBlock() == this) {
                state = state.withProperty((IProperty)FACING, iblockstate.getValue((IProperty)FACING)).withProperty((IProperty)OPEN, iblockstate.getValue((IProperty)OPEN));
            }
        }
        return state;
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return state.getValue(HALF) == EnumGateHalf.UPPER ? Items.AIR : ItemRegistry.TALL_GATE;
    }

    public ItemStack getItem(World worldIn, BlockPos pos, IBlockState state) {
        return state.getValue(HALF) == EnumGateHalf.UPPER ? ItemStack.EMPTY : new ItemStack(ItemRegistry.TALL_GATE, 1, ItemTallGate.getMetaFromBlock((Block)this));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.getValue(HALF) == EnumGateHalf.LOWER) {
            drops.add((Object)new ItemStack(ItemRegistry.TALL_GATE, 1, ItemTallGate.getMetaFromBlock((Block)this)));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ItemRegistry.TALL_GATE, 1, ItemTallGate.getMetaFromBlock((Block)this));
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.getValue(HALF) != EnumGateHalf.LOWER ? state : state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        if (pos.getY() >= worldIn.getHeight() - 1) {
            return false;
        }
        IBlockState state = worldIn.getBlockState(pos.down());
        return state.getMaterial().isSolid() && worldIn.getBlockState(pos).getBlock().isReplaceable((IBlockAccess)worldIn, pos) && worldIn.getBlockState(pos).getBlock().isReplaceable((IBlockAccess)worldIn, pos.up());
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (((Boolean)(blockState = this.getActualState(blockState, worldIn, pos)).getValue((IProperty)OPEN)).booleanValue()) {
            return NULL_AABB;
        }
        return ((EnumFacing)blockState.getValue((IProperty)FACING)).getAxis() == EnumFacing.Axis.Z ? AABB_COLLISION_BOX_ZAXIS : AABB_COLLISION_BOX_XAXIS;
    }

    public boolean isPassable(IBlockAccess worldIn, BlockPos pos) {
        return BlockTallGate.isOpen(BlockTallGate.combineMetadata(worldIn, pos));
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        boolean flag = worldIn.isBlockPowered(pos);
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing()).withProperty((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)).withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState stateDown;
        BlockPos blockpos = state.getValue(HALF) == EnumGateHalf.LOWER ? pos : pos.down();
        IBlockState iBlockState = stateDown = pos.equals((Object)blockpos) ? state : worldIn.getBlockState(blockpos);
        if (stateDown.getBlock() != this) {
            return false;
        }
        if (((Boolean)stateDown.getValue((IProperty)OPEN)).booleanValue()) {
            stateDown = stateDown.withProperty((IProperty)OPEN, (Comparable)Boolean.FALSE);
            worldIn.setBlockState(blockpos, stateDown, 10);
        } else {
            EnumFacing enumfacing = EnumFacing.fromAngle((double)playerIn.rotationYaw);
            if (stateDown.getValue((IProperty)FACING) == enumfacing.getOpposite()) {
                stateDown = stateDown.withProperty((IProperty)FACING, (Comparable)enumfacing);
            }
            stateDown = stateDown.withProperty((IProperty)OPEN, (Comparable)Boolean.TRUE);
            worldIn.setBlockState(blockpos, stateDown, 10);
        }
        worldIn.markBlockRangeForRenderUpdate(blockpos, pos);
        worldIn.playEvent(playerIn, (Boolean)state.getValue((IProperty)OPEN) != false ? 1008 : 1014, pos, 0);
        return true;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.getValue(HALF) == EnumGateHalf.UPPER) {
            BlockPos posDown = pos.down();
            IBlockState stateDown = worldIn.getBlockState(posDown);
            if (stateDown.getBlock() != this) {
                worldIn.setBlockToAir(pos);
            } else if (blockIn != this) {
                stateDown.neighborChanged(worldIn, posDown, blockIn, fromPos);
            }
        } else {
            BlockPos posUp = pos.up();
            IBlockState stateUp = worldIn.getBlockState(posUp);
            if (stateUp.getBlock() != this) {
                worldIn.setBlockToAir(pos);
                if (!worldIn.isRemote) {
                    this.dropBlockAsItem(worldIn, pos, state, 0);
                }
            } else {
                boolean flag;
                boolean bl = flag = worldIn.isBlockPowered(pos) || worldIn.isBlockPowered(posUp);
                if ((Boolean)stateUp.getValue((IProperty)POWERED) != flag) {
                    worldIn.setBlockState(posUp, stateUp.withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
                    worldIn.setBlockState(pos, state.withProperty((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
                    if (flag != (Boolean)state.getValue((IProperty)OPEN)) {
                        worldIn.markBlockRangeForRenderUpdate(pos, pos);
                        worldIn.playEvent(null, flag ? 1008 : 1014, pos, 0);
                    }
                }
            }
        }
    }

    public void onBlockHarvested(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos = pos.down();
        BlockPos blockpos1 = pos.up();
        if (player.capabilities.isCreativeMode && state.getValue(HALF) == EnumGateHalf.UPPER && worldIn.getBlockState(blockpos).getBlock() == this) {
            worldIn.setBlockToAir(blockpos);
        }
        if (state.getValue(HALF) == EnumGateHalf.LOWER && worldIn.getBlockState(blockpos1).getBlock() == this) {
            if (player.capabilities.isCreativeMode) {
                worldIn.setBlockToAir(pos);
            }
            worldIn.setBlockToAir(blockpos1);
        }
    }

    public IBlockState getStateFromMeta(int meta) {
        return (meta & 8) > 0 ? this.getDefaultState().withProperty(HALF, (Comparable)((Object)EnumGateHalf.UPPER)).withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 1) > 0)) : this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.getHorizontal((int)meta)).withProperty((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public int getMetaFromState(IBlockState state) {
        int i = 0;
        if (state.getValue(HALF) == EnumGateHalf.UPPER) {
            i |= 8;
            if (((Boolean)state.getValue((IProperty)POWERED)).booleanValue()) {
                i |= 1;
            }
        } else {
            i |= ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
            if (((Boolean)state.getValue((IProperty)OPEN)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    public static int combineMetadata(IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.getBlockState(pos);
        int i = iblockstate.getBlock().getMetaFromState(iblockstate);
        boolean flag = BlockTallGate.isTop(i);
        IBlockState iblockstate1 = worldIn.getBlockState(pos.down());
        int j = iblockstate1.getBlock().getMetaFromState(iblockstate1);
        int k = flag ? j : i;
        IBlockState iblockstate2 = worldIn.getBlockState(pos.up());
        int l = iblockstate2.getBlock().getMetaFromState(iblockstate2);
        int i1 = flag ? i : l;
        boolean flag1 = (i1 & 1) != 0;
        boolean flag2 = (i1 & 2) != 0;
        return BlockTallGate.removeHalfBit(k) | (flag ? 8 : 0) | (flag1 ? 16 : 0) | (flag2 ? 32 : 0);
    }

    private static int removeHalfBit(int meta) {
        return meta & 7;
    }

    private static boolean isOpen(int combinedMeta) {
        return (combinedMeta & 4) != 0;
    }

    private static boolean isTop(int meta) {
        return (meta & 8) != 0;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, FACING, OPEN, IN_WALL, POWERED});
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        state = this.getActualState(state, worldIn, pos);
        if (face != EnumFacing.UP && face != EnumFacing.DOWN) {
            return ((EnumFacing)state.getValue((IProperty)FACING)).getAxis() == face.rotateY().getAxis() ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public ItemStack getRenderedItem() {
        return new ItemStack(ItemRegistry.TALL_GATE);
    }

    @Override
    public void setStateMapper(StateMap.Builder builder) {
        builder.ignore(new IProperty[]{POWERED}).ignore(new IProperty[]{IN_WALL});
    }

    public static enum EnumGateHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.getName();
        }

        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

