package gory_moon.moarsigns.items;

import com.google.common.collect.Maps;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.ShapedMoarSignRecipe;
import gory_moon.moarsigns.api.ShapelessMoarSignRecipe;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.lib.Info;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ModItems {

    public static ItemMoarSign SIGN;
    public static ItemDebug DEBUG;
    public static ItemNugget NUGGET;
    public static ItemSignToolbox SIGN_TOOLBOX;

    public static boolean replaceRecipes = true;

    public static void init() {

        SIGN = (ItemMoarSign) new ItemMoarSign().setRegistryName(Info.SIGN_ITEM_KEY);
        DEBUG = (ItemDebug) new ItemDebug().setRegistryName(Info.DEBUG_ITEM_KEY);
        NUGGET = (ItemNugget) new ItemNugget().setRegistryName(Info.NUGGET_ITEM_KEY);
        SIGN_TOOLBOX = (ItemSignToolbox) new ItemSignToolbox().setRegistryName(Info.SIGN_TOOLBOX_ITEM_KEY);

        GameRegistry.register(SIGN);
        GameRegistry.register(DEBUG);
        GameRegistry.register(NUGGET);
        GameRegistry.register(SIGN_TOOLBOX);
    }

    public static void registerRecipes() {
        RecipeSorter.register("moarsigns:shaped", ShapedMoarSignRecipe.class, RecipeSorter.Category.SHAPED, "after:minecraft:shaped before:minecraft:shapeless");
        RecipeSorter.register("moarsigns:shapeless", ShapelessMoarSignRecipe.class, RecipeSorter.Category.SHAPELESS, "after:minecraft:shapeless");
        removeRecipesWithResult(new ItemStack(Items.field_151155_ap, 3));

        List<SignInfo> signRegistry = SignRegistry.getActivatedSignRegistry();

        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        SIGN.getSubItemStacks(list);

        ItemStack generalSign = null;

        Container dummyContainer = new Container() {
            @Override
            public boolean func_75145_c(EntityPlayer entityplayer) {
                return true;
            }

            @Override
            public void func_75130_a(IInventory par1IInventory) {
            }
        };
        InventoryCrafting crafting = new InventoryCrafting(dummyContainer, 2, 2);

        for (ItemStack stack : list) {

            ItemMoarSign sign = (ItemMoarSign) stack.func_77973_b();
            String texture = sign.getTextureFromNBTFull(stack.func_77978_p());
            boolean isMetal = stack.func_77952_i() == 1;

            stack.field_77994_a = 3;

            if (texture.equals("oak_sign")) {
                generalSign = stack;
                continue;
            }

            SignInfo s = SignRegistry.get(texture);
            ItemStack mat = s != null ? s.material.material : null;
            if (mat != null && mat.func_77973_b() != null) {
                if (isMetal) {
                    mat.field_77994_a = 1;
                    if (mat.func_77973_b() instanceof ItemBlock) {
                        crafting.func_70299_a(0, mat);
                        mat = CraftingManager.func_77594_a().func_82787_a(crafting, null);
                    }
                    ItemStack recNugget = null;
                    mat.field_77994_a = 1;

                    if (!s.material.gotNugget) {
                        String unlocName = mat.func_77977_a();
                        for (int i = 0; i < NuggetRegistry.size(); i++) {

                            if (NuggetRegistry.getIngotName(i).equals(unlocName)) {
                                NuggetRegistry.setNeeded(i, true);
                                recNugget = new ItemStack(NUGGET, 1, i);
                                OreDictionary.registerOre(NuggetRegistry.getOreName(i), recNugget.func_77946_l());

                                recNugget.field_77994_a = 9;
                                GameRegistry.addShapelessRecipe(recNugget.func_77946_l(), mat);
                                GameRegistry.addRecipe(new ShapedOreRecipe(mat, "xxx", "xxx", "xxx", 'x', NuggetRegistry.getOreName(i)));
                                break;
                            }
                        }
                    } else {
                        crafting.func_70299_a(0, mat);
                        recNugget = CraftingManager.func_77594_a().func_82787_a(crafting, null);
                    }

                    if (recNugget != null && recNugget.func_77973_b() != null) {
                        ItemStack stack1 = stack.func_77946_l();
                        stack1.field_77994_a = 1;
                        recNugget.field_77994_a = 1;
                        if (recNugget.func_77977_a().equals("item.moarsigns.diamond_nugget")) {
                            GameRegistry.addRecipe(new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", 'X', "diamondNugget", '/', "stickWood"));
                            GameRegistry.addRecipe(new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", 'X', "nuggetDiamond", '/', "stickWood"));
                        } else if (recNugget.func_77977_a().equals("item.moarsigns.iron_nugget"))
                            GameRegistry.addRecipe(new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", 'X', "nuggetIron", '/', "stickWood"));
                        else if (recNugget.func_77977_a().equals("item.moarsigns.emerald_nugget"))
                            GameRegistry.addRecipe(new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", 'X', "nuggetEmerald", '/', "stickWood"));
                        else if (recNugget.func_77977_a().equals("item.moarsigns.lapis_nugget"))
                            GameRegistry.addRecipe(new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", 'X', "nuggetLapis", '/', "stickWood"));
                        else if (recNugget.func_77977_a().equals("item.moarsigns.quartz_nugget"))
                            GameRegistry.addRecipe(new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", 'X', "nuggetQuartz", '/', "stickWood"));
                        else
                            GameRegistry.addRecipe(new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", 'X', recNugget, '/', "stickWood"));
                    }

                    stack.field_77994_a = 9;
                }
                if (mat.func_77977_a().equals(Items.field_151045_i.func_77658_a()))
                    GameRegistry.addRecipe(new ShapedMoarSignRecipe(stack, true, true, "XXX", "XXX", " / ", 'X', "gemDiamond", '/', "stickWood"));
                else if (mat.func_77977_a().equals(Items.field_151166_bC.func_77658_a()))
                    GameRegistry.addRecipe(new ShapedMoarSignRecipe(stack, true, true, "XXX", "XXX", " / ", 'X', "gemEmerald", '/', "stickWood"));
                else if (mat.func_77977_a().equals(Items.field_151042_j.func_77658_a()))
                    GameRegistry.addRecipe(new ShapedMoarSignRecipe(stack, true, true, "XXX", "XXX", " / ", 'X', "ingotIron", '/', "stickWood"));
                else
                    GameRegistry.addRecipe(new ShapedMoarSignRecipe(stack, true, true, "XXX", "XXX", " / ", 'X', mat, '/', "stickWood"));
            }
        }

        GameRegistry.addRecipe(new ShapedMoarSignRecipe(generalSign, true, true, "###", "###", " X ", '#', "plankWood", 'X', "stickWood"));
        GameRegistry.addRecipe(new ShapedMoarSignRecipe(SIGN_TOOLBOX, "rxr", "xsx", "rxr", 'x', "ingotIron", 's', ShapedMoarSignRecipe.MatchType.ALL, 'r', "dyeRed"));

        if (replaceRecipes) {
            ArrayList recipes = (ArrayList) CraftingManager.func_77594_a().func_77592_b();
            ItemStack signStack = new ItemStack(Items.field_151155_ap);
            for (int scan = 0; scan < recipes.size(); scan++) {
                IRecipe tmpRecipe = (IRecipe) recipes.get(scan);
                List input = null;

                if (tmpRecipe instanceof ShapedRecipes) {
                    input = Arrays.asList(((ShapedRecipes) tmpRecipe).field_77574_d);
                } else if (tmpRecipe instanceof ShapelessRecipes) {
                    input = ((ShapelessRecipes) tmpRecipe).field_77579_b;
                } else if (tmpRecipe instanceof ShapedOreRecipe) {
                    input = Arrays.asList(((ShapedOreRecipe) tmpRecipe).getInput());
                } else if (tmpRecipe instanceof ShapelessOreRecipe) {
                    input = ((ShapelessOreRecipe) tmpRecipe).getInput();
                }

                if (input != null) {
                    for (Object stack : input) {
                        if (stack instanceof ItemStack && OreDictionary.itemMatches((ItemStack) stack, signStack, false)) {
                            HashMap<ItemStack, Object> map = Maps.newHashMap();
                            map.put(signStack, ShapedMoarSignRecipe.MatchType.ALL);

                            IRecipe replacement = null;
                            if (tmpRecipe instanceof ShapedRecipes || tmpRecipe instanceof ShapedOreRecipe)
                                GameRegistry.addRecipe(replacement = new ShapedMoarSignRecipe(tmpRecipe, map));
                            if (tmpRecipe instanceof ShapelessRecipes || tmpRecipe instanceof ShapelessOreRecipe)
                                GameRegistry.addRecipe(replacement = new ShapelessMoarSignRecipe(tmpRecipe, map));

                            MoarSigns.logger.info("Replacing Recipe: " + tmpRecipe + " (containing " + stack + ") -> " + replacement);
                            recipes.remove(scan);
                        }
                    }
                }
            }
        }
    }


    private static void removeRecipesWithResult(ItemStack resultItem) {
        ArrayList recipes = (ArrayList) CraftingManager.func_77594_a().func_77592_b();

        for (int scan = 0; scan < recipes.size(); scan++) {
            IRecipe tmpRecipe = (IRecipe) recipes.get(scan);
            ItemStack recipeResult = tmpRecipe.func_77571_b();
            if (ItemStack.func_77989_b(resultItem, recipeResult)) {
                MoarSigns.logger.debug("Removing Recipe: " + recipes.get(scan) + " -> " + recipeResult);
                recipes.remove(scan);
            }
        }
    }

}
