/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import com.google.common.collect.Maps;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.ShapedMoarSignRecipe;
import gory_moon.moarsigns.api.ShapelessMoarSignRecipe;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.items.ItemDebug;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ItemNugget;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.NuggetRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ModItems {
    public static ItemMoarSign SIGN;
    public static ItemDebug DEBUG;
    public static ItemNugget NUGGET;
    public static ItemSignToolbox SIGN_TOOLBOX;
    public static boolean replaceRecipes;

    public static void init() {
        SIGN = (ItemMoarSign)new ItemMoarSign().setRegistryName("moar_sign");
        DEBUG = (ItemDebug)new ItemDebug().setRegistryName("debug");
        NUGGET = (ItemNugget)new ItemNugget().setRegistryName("nugget");
        SIGN_TOOLBOX = (ItemSignToolbox)new ItemSignToolbox().setRegistryName("sign_toolbox");
        GameRegistry.register((IForgeRegistryEntry)SIGN);
        GameRegistry.register((IForgeRegistryEntry)DEBUG);
        GameRegistry.register((IForgeRegistryEntry)NUGGET);
        GameRegistry.register((IForgeRegistryEntry)SIGN_TOOLBOX);
    }

    public static void registerRecipes() {
        RecipeSorter.register((String)"moarsigns:shaped", ShapedMoarSignRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:minecraft:shapeless");
        RecipeSorter.register((String)"moarsigns:shapeless", ShapelessMoarSignRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        ModItems.removeRecipesWithResult(new ItemStack(Items.SIGN, 3));
        ArrayList<SignInfo> signRegistry = SignRegistry.getActivatedSignRegistry();
        ArrayList list = new ArrayList();
        SIGN.getSubItemStacks(list);
        ItemStack generalSign = null;
        Container dummyContainer = new Container(){

            public boolean canInteractWith(EntityPlayer entityplayer) {
                return true;
            }

            public void onCraftMatrixChanged(IInventory par1IInventory) {
            }
        };
        InventoryCrafting crafting = new InventoryCrafting(dummyContainer, 2, 2);
        for (ItemStack stack : list) {
            ItemMoarSign sign = (ItemMoarSign)stack.getItem();
            String texture = ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound());
            boolean isMetal = stack.getItemDamage() == 1;
            stack.stackSize = 3;
            if (texture.equals("oak_sign")) {
                generalSign = stack;
                continue;
            }
            SignInfo s = SignRegistry.get(texture);
            ItemStack mat = s != null ? s.material.material : null;
            if (mat == null || mat.getItem() == null) continue;
            if (isMetal) {
                mat.stackSize = 1;
                if (mat.getItem() instanceof ItemBlock) {
                    crafting.setInventorySlotContents(0, mat);
                    mat = CraftingManager.getInstance().findMatchingRecipe(crafting, null);
                }
                ItemStack recNugget = null;
                mat.stackSize = 1;
                if (!s.material.gotNugget) {
                    String unlocName = mat.getUnlocalizedName();
                    for (int i = 0; i < NuggetRegistry.size(); ++i) {
                        if (!NuggetRegistry.getIngotName(i).equals(unlocName)) continue;
                        NuggetRegistry.setNeeded(i, true);
                        recNugget = new ItemStack((Item)NUGGET, 1, i);
                        OreDictionary.registerOre((String)NuggetRegistry.getOreName(i), (ItemStack)recNugget.copy());
                        recNugget.stackSize = 9;
                        GameRegistry.addShapelessRecipe((ItemStack)recNugget.copy(), (Object[])new Object[]{mat});
                        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(mat, new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), NuggetRegistry.getOreName(i)}));
                        break;
                    }
                } else {
                    crafting.setInventorySlotContents(0, mat);
                    recNugget = CraftingManager.getInstance().findMatchingRecipe(crafting, null);
                }
                if (recNugget != null && recNugget.getItem() != null) {
                    ItemStack stack1 = stack.copy();
                    stack1.stackSize = 1;
                    recNugget.stackSize = 1;
                    if (recNugget.getUnlocalizedName().equals("item.moarsigns.diamond_nugget")) {
                        GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "diamondNugget", Character.valueOf('/'), "stickWood"));
                        GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "nuggetDiamond", Character.valueOf('/'), "stickWood"));
                    } else if (recNugget.getUnlocalizedName().equals("item.moarsigns.iron_nugget")) {
                        GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "nuggetIron", Character.valueOf('/'), "stickWood"));
                    } else if (recNugget.getUnlocalizedName().equals("item.moarsigns.emerald_nugget")) {
                        GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "nuggetEmerald", Character.valueOf('/'), "stickWood"));
                    } else if (recNugget.getUnlocalizedName().equals("item.moarsigns.lapis_nugget")) {
                        GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "nuggetLapis", Character.valueOf('/'), "stickWood"));
                    } else if (recNugget.getUnlocalizedName().equals("item.moarsigns.quartz_nugget")) {
                        GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "nuggetQuartz", Character.valueOf('/'), "stickWood"));
                    } else {
                        GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(stack1, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), recNugget, Character.valueOf('/'), "stickWood"));
                    }
                }
                stack.stackSize = 9;
            }
            if (mat.getUnlocalizedName().equals(Items.DIAMOND.getUnlocalizedName())) {
                GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(stack, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "gemDiamond", Character.valueOf('/'), "stickWood"));
                continue;
            }
            if (mat.getUnlocalizedName().equals(Items.EMERALD.getUnlocalizedName())) {
                GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(stack, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "gemEmerald", Character.valueOf('/'), "stickWood"));
                continue;
            }
            if (mat.getUnlocalizedName().equals(Items.IRON_INGOT.getUnlocalizedName())) {
                GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(stack, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), "ingotIron", Character.valueOf('/'), "stickWood"));
                continue;
            }
            GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(stack, true, true, "XXX", "XXX", " / ", Character.valueOf('X'), mat, Character.valueOf('/'), "stickWood"));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(generalSign, true, true, "###", "###", " X ", Character.valueOf('#'), "plankWood", Character.valueOf('X'), "stickWood"));
        GameRegistry.addRecipe((IRecipe)new ShapedMoarSignRecipe(SIGN_TOOLBOX, new Object[]{"rxr", "xsx", "rxr", Character.valueOf('x'), "ingotIron", Character.valueOf('s'), ShapedMoarSignRecipe.MatchType.ALL, Character.valueOf('r'), "dyeRed"}));
        if (replaceRecipes) {
            ArrayList recipes = (ArrayList)CraftingManager.getInstance().getRecipeList();
            ItemStack signStack = new ItemStack(Items.SIGN);
            for (int scan = 0; scan < recipes.size(); ++scan) {
                IRecipe tmpRecipe = (IRecipe)recipes.get(scan);
                ArrayList input = null;
                if (tmpRecipe instanceof ShapedRecipes) {
                    input = Arrays.asList(((ShapedRecipes)tmpRecipe).recipeItems);
                } else if (tmpRecipe instanceof ShapelessRecipes) {
                    input = ((ShapelessRecipes)tmpRecipe).recipeItems;
                } else if (tmpRecipe instanceof ShapedOreRecipe) {
                    input = Arrays.asList(((ShapedOreRecipe)tmpRecipe).getInput());
                } else if (tmpRecipe instanceof ShapelessOreRecipe) {
                    input = ((ShapelessOreRecipe)tmpRecipe).getInput();
                }
                if (input == null) continue;
                for (Object stack : input) {
                    if (!(stack instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)((ItemStack)stack), (ItemStack)signStack, (boolean)false)) continue;
                    HashMap map = Maps.newHashMap();
                    map.put(signStack, ShapedMoarSignRecipe.MatchType.ALL);
                    Object replacement = null;
                    if (tmpRecipe instanceof ShapedRecipes || tmpRecipe instanceof ShapedOreRecipe) {
                        replacement = new ShapedMoarSignRecipe(tmpRecipe, map);
                        GameRegistry.addRecipe((IRecipe)replacement);
                    }
                    if (tmpRecipe instanceof ShapelessRecipes || tmpRecipe instanceof ShapelessOreRecipe) {
                        replacement = new ShapelessMoarSignRecipe(tmpRecipe, map);
                        GameRegistry.addRecipe((IRecipe)replacement);
                    }
                    MoarSigns.logger.info("Replacing Recipe: " + tmpRecipe + " (containing " + stack + ") -> " + replacement);
                    recipes.remove(scan);
                }
            }
        }
    }

    private static void removeRecipesWithResult(ItemStack resultItem) {
        ArrayList recipes = (ArrayList)CraftingManager.getInstance().getRecipeList();
        for (int scan = 0; scan < recipes.size(); ++scan) {
            IRecipe tmpRecipe = (IRecipe)recipes.get(scan);
            ItemStack recipeResult = tmpRecipe.getRecipeOutput();
            if (!ItemStack.areItemStacksEqual((ItemStack)resultItem, (ItemStack)recipeResult)) continue;
            MoarSigns.logger.debug("Removing Recipe: " + recipes.get(scan) + " -> " + recipeResult);
            recipes.remove(scan);
        }
    }

    static {
        replaceRecipes = true;
    }
}

