package gory_moon.moarsigns.proxy;

import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.BlockMoarSignStanding;
import gory_moon.moarsigns.blocks.BlockMoarSignWall;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.client.ModelsMoarSigns;
import gory_moon.moarsigns.client.layer.LayerMoarSign;
import gory_moon.moarsigns.client.renderers.MoarSignRenderer;
import gory_moon.moarsigns.integration.IntegrationHandler;
import gory_moon.moarsigns.items.MoarSignsItemMeshDefenition;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientProxy extends CommonProxy {

    @Override
    public void preInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMoarSign.class, new MoarSignRenderer());
        new IntegrationHandler().preSetupSigns();
    }

    @Override
    public void registerModels() {
        ModelsMoarSigns.prepareModels();
        ModelsMoarSigns.registerModels();
        SignRegistry.clear();

        //ModelLoader.addCustomBuiltInBlocks(Blocks.signStandingMetal, Blocks.signStandingWood, Blocks.signWallMetal, Blocks.signWallWood);
        ModelLoader.setCustomMeshDefinition(ModItems.SIGN, new MoarSignsItemMeshDefenition());

        ModelLoader.setCustomStateMapper(Blocks.signStandingWood, (new StateMap.Builder()).func_178442_a(new IProperty[] {BlockMoarSignStanding.ROTATION}).func_178441_a());
        ModelLoader.setCustomStateMapper(Blocks.signStandingMetal, (new StateMap.Builder()).func_178442_a(new IProperty[] {BlockMoarSignStanding.ROTATION}).func_178441_a());
        ModelLoader.setCustomStateMapper(Blocks.signWallWood, (new StateMap.Builder()).func_178442_a(new IProperty[] {BlockMoarSignWall.ROTATION, BlockMoarSignWall.FACING}).func_178441_a());
        ModelLoader.setCustomStateMapper(Blocks.signWallMetal, (new StateMap.Builder()).func_178442_a(new IProperty[] {BlockMoarSignWall.ROTATION, BlockMoarSignWall.FACING}).func_178441_a());
    }

    @Override
    public void init() {
        LayerMoarSign layer = new LayerMoarSign();
        ((RenderPlayer) Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("default")).func_177094_a(layer);
        ((RenderPlayer) Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("slim")).func_177094_a(layer);
    }
}
