/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.interfaces;

import gory_moon.moarsigns.client.interfaces.GuiBase;
import java.util.Arrays;

public class GuiRectangle {
    protected int x;
    protected int y;
    protected int w;
    protected int h;

    public GuiRectangle(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public boolean inRect(int mouseX, int mouseY) {
        return this.x <= mouseX && mouseX < this.x + this.w && this.y <= mouseY && mouseY < this.y + this.h;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public void draw(GuiBase gui, int srcX, int srcY) {
        gui.drawTexturedModalRect(this.x, this.y, srcX, srcY, this.w, this.h);
    }

    public void drawString(GuiBase gui, int mouseX, int mouseY, String str) {
        if (!gui.isOnOverlay(mouseX, mouseY) && this.inRect(mouseX, mouseY) && str != null) {
            String[] list = str.split("\n");
            for (int i = 0; i < list.length; ++i) {
                list[i] = list[i].trim();
            }
            gui.drawHoveringText(Arrays.asList(list), mouseX, mouseY, gui.getFontRenderer());
        }
    }
}

