/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network.message;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.network.ClientMessageHandler;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.Charset;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSignMainInfo
implements IMessage {
    public BlockPos pos;
    public String texture;
    public boolean isMetal;
    public int[] rowLocations = new int[4];
    public int[] rowSizes = new int[]{0, 0, 0, 0};
    public boolean[] visibleRows = new boolean[]{true, true, true, true};
    public boolean[] shadowRows = new boolean[4];
    public boolean lockedChanges;
    public IChatComponent[] text;

    public MessageSignMainInfo() {
    }

    public MessageSignMainInfo(BlockPos pos, String texture, boolean isMetal, int[] rowLocations, int[] rowSizes, boolean[] visibleRows, boolean[] shadowRows, boolean lockedChanges, IChatComponent[] text) {
        this.pos = pos;
        this.texture = texture;
        this.isMetal = isMetal;
        this.rowLocations = rowLocations;
        this.rowSizes = rowSizes;
        this.visibleRows = visibleRows;
        this.shadowRows = shadowRows;
        this.lockedChanges = lockedChanges;
        this.text = text;
    }

    public MessageSignMainInfo(TileEntityMoarSign tileEntity) {
        this(tileEntity.getPos(), tileEntity.texture_name, tileEntity.isMetal, tileEntity.rowLocations, tileEntity.rowSizes, tileEntity.visibleRows, tileEntity.shadowRows, tileEntity.lockedChanges, tileEntity.signText);
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        this.pos = packetBuf.readBlockPos();
        this.text = new IChatComponent[4];
        if (packetBuf.readBoolean()) {
            int i;
            int textureLength = packetBuf.readInt();
            this.texture = new String(packetBuf.readBytes(textureLength).array(), Charset.forName("utf-8"));
            this.isMetal = packetBuf.readBoolean();
            for (i = 0; i < 4; ++i) {
                this.rowLocations[i] = packetBuf.readInt();
            }
            for (i = 0; i < 4; ++i) {
                this.rowSizes[i] = packetBuf.readInt();
            }
            for (i = 0; i < 4; ++i) {
                this.visibleRows[i] = packetBuf.readBoolean();
            }
            for (i = 0; i < 4; ++i) {
                this.shadowRows[i] = packetBuf.readBoolean();
            }
            this.lockedChanges = packetBuf.readBoolean();
            for (i = 0; i < 4; ++i) {
                try {
                    this.text[i] = packetBuf.readChatComponent();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        packetBuf.writeBlockPos(this.pos);
        if (this.texture != null && this.rowLocations != null && this.rowSizes != null && this.visibleRows != null && this.text != null) {
            int i;
            packetBuf.writeBoolean(true);
            packetBuf.writeInt(this.texture.length());
            packetBuf.writeBytes(this.texture.getBytes(Charset.forName("utf-8")));
            packetBuf.writeBoolean(this.isMetal);
            for (i = 0; i < 4; ++i) {
                packetBuf.writeInt(this.rowLocations[i]);
            }
            for (i = 0; i < 4; ++i) {
                packetBuf.writeInt(this.rowSizes[i]);
            }
            for (i = 0; i < 4; ++i) {
                packetBuf.writeBoolean(this.visibleRows[i]);
            }
            for (i = 0; i < 4; ++i) {
                packetBuf.writeBoolean(this.shadowRows[i]);
            }
            packetBuf.writeBoolean(this.lockedChanges);
            for (i = 0; i < 4; ++i) {
                try {
                    packetBuf.writeChatComponent(this.text[i]);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public static class Handler
    extends ClientMessageHandler<MessageSignMainInfo> {
        @Override
        protected void handle(MessageSignMainInfo message, MessageContext ctx) {
            WorldClient world = FMLClientHandler.instance().getClient().theWorld;
            boolean flag = false;
            if (message.texture != null && message.rowLocations != null && message.rowSizes != null && message.visibleRows != null && message.shadowRows != null && message.text != null) {
                TileEntity tileEntity;
                if (world.isBlockLoaded(message.pos) && (tileEntity = world.getTileEntity(message.pos)) instanceof TileEntityMoarSign) {
                    TileEntityMoarSign sign = (TileEntityMoarSign)tileEntity;
                    if (sign.getIsEditable()) {
                        sign.isMetal = message.isMetal;
                        sign.rowLocations = message.rowLocations;
                        sign.rowSizes = message.rowSizes;
                        sign.visibleRows = message.visibleRows;
                        sign.shadowRows = message.shadowRows;
                        sign.lockedChanges = message.lockedChanges;
                        sign.setResourceLocation(message.texture);
                        System.arraycopy(message.text, 0, sign.signText, 0, 4);
                        sign.markDirty();
                    }
                    flag = true;
                }
                if (!flag && FMLClientHandler.instance().getClient().thePlayer != null) {
                    MoarSigns.logger.info("Unable to locate sign at " + message.pos.toString());
                    FMLClientHandler.instance().getClient().thePlayer.addChatMessage((IChatComponent)new ChatComponentText("Unable to locate sign at " + message.pos.getX() + ", " + message.pos.getY() + ", " + message.pos.getZ()));
                }
            } else {
                MoarSigns.logger.error("An error with packages occurred");
            }
        }
    }
}

