/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network.message;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.network.ServerMessageHandler;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSignUpdate
implements IMessage {
    public BlockPos pos;
    public int[] rowLocations = new int[4];
    public int[] rowSizes = new int[]{0, 0, 0, 0};
    public boolean[] visibleRows = new boolean[]{true, true, true, true};
    public boolean[] shadowRows = new boolean[4];
    public boolean lockedChanges;
    public IChatComponent[] text;

    public MessageSignUpdate() {
    }

    public MessageSignUpdate(BlockPos pos, int[] rowLocations, int[] rowSizes, boolean[] visibleRows, boolean[] shadowRows, boolean lockedChanges, IChatComponent[] text) {
        this.pos = pos;
        this.rowLocations = rowLocations;
        this.rowSizes = rowSizes;
        this.visibleRows = visibleRows;
        this.shadowRows = shadowRows;
        this.lockedChanges = lockedChanges;
        this.text = text;
    }

    public MessageSignUpdate(TileEntityMoarSign tileEntity) {
        this(tileEntity.getPos(), tileEntity.rowLocations, tileEntity.rowSizes, tileEntity.visibleRows, tileEntity.shadowRows, tileEntity.lockedChanges, tileEntity.signText);
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        PacketBuffer packetBuf = new PacketBuffer(buf);
        this.pos = packetBuf.readBlockPos();
        this.text = new IChatComponent[4];
        for (i = 0; i < 4; ++i) {
            this.rowLocations[i] = packetBuf.readInt();
        }
        for (i = 0; i < 4; ++i) {
            this.rowSizes[i] = packetBuf.readInt();
        }
        for (i = 0; i < 4; ++i) {
            this.visibleRows[i] = packetBuf.readBoolean();
        }
        for (i = 0; i < 4; ++i) {
            this.shadowRows[i] = packetBuf.readBoolean();
        }
        this.lockedChanges = packetBuf.readBoolean();
        for (i = 0; i < 4; ++i) {
            try {
                this.text[i] = packetBuf.readChatComponent();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        int i;
        PacketBuffer packetBuf = new PacketBuffer(buf);
        packetBuf.writeBlockPos(this.pos);
        for (i = 0; i < 4; ++i) {
            packetBuf.writeInt(this.rowLocations[i]);
        }
        for (i = 0; i < 4; ++i) {
            packetBuf.writeInt(this.rowSizes[i]);
        }
        for (i = 0; i < 4; ++i) {
            packetBuf.writeBoolean(this.visibleRows[i]);
        }
        for (i = 0; i < 4; ++i) {
            packetBuf.writeBoolean(this.shadowRows[i]);
        }
        packetBuf.writeBoolean(this.lockedChanges);
        for (i = 0; i < 4; ++i) {
            try {
                packetBuf.writeChatComponent(this.text[i]);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Handler
    extends ServerMessageHandler<MessageSignUpdate> {
        @Override
        protected void handle(MessageSignUpdate message, MessageContext ctx) {
            TileEntity tileentity;
            EntityPlayerMP player = ctx.getServerHandler().playerEntity;
            player.markPlayerActive();
            WorldServer worldserver = MinecraftServer.getServer().worldServerForDimension(player.dimension);
            BlockPos pos = message.pos;
            if (worldserver.isBlockLoaded(pos) && (tileentity = worldserver.getTileEntity(pos)) instanceof TileEntityMoarSign) {
                TileEntityMoarSign tileentitysign = (TileEntityMoarSign)tileentity;
                if (!tileentitysign.getIsEditable() || tileentitysign.getPlayer() != player) {
                    MoarSigns.logger.warn("Player " + player.getName() + " just tried to change non-editable sign");
                    return;
                }
                tileentitysign.rowLocations = message.rowLocations;
                tileentitysign.rowSizes = message.rowSizes;
                tileentitysign.visibleRows = message.visibleRows;
                tileentitysign.shadowRows = message.shadowRows;
                tileentitysign.lockedChanges = message.lockedChanges;
                IChatComponent[] components = message.text;
                for (int i = 0; i < components.length; ++i) {
                    tileentitysign.signText[i] = new ChatComponentText(components[i].getUnformattedText());
                }
                tileentitysign.markDirty();
                worldserver.markBlockForUpdate(pos);
            }
        }
    }
}

