/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.interfaces;

import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.client.interfaces.containers.ContainerPreview;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiPreview
extends GuiContainer {
    private static final ResourceLocation texture = new ResourceLocation("moarsigns", "textures/gui/sign_preview.png");
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private boolean firstDraw;
    private TileEntityMoarSign sign;
    private float roll;
    private float yaw;
    private int scrollX;
    private int scrollY;
    private boolean isDraging;
    private boolean isSpinning = true;
    private boolean rollDown;

    public GuiPreview() {
        super((Container)new ContainerPreview());
        this.xSize = 226;
        this.ySize = 140;
        this.allowUserInput = true;
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        ContainerPreview containerPreview = (ContainerPreview)this.inventorySlots;
        containerPreview.itemList.clear();
        ModItems.sign.getSubItemStacks(containerPreview.itemList);
    }

    public void drawScreen(int x, int y, float renderPartialTicks) {
        if (!this.firstDraw) {
            this.currentScroll = 0.0f;
            ((ContainerPreview)this.inventorySlots).scrollTo(0.0f);
            this.firstDraw = true;
        }
        boolean buttonDown = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && buttonDown && x >= this.guiLeft + 101 && y >= this.guiTop + 8 && x < this.guiLeft + 113 && y < this.guiTop + 132) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!buttonDown) {
            this.isScrolling = false;
        }
        this.wasClicking = buttonDown;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.guiTop - 8) - 7.5f) / 102.0f;
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
            ((ContainerPreview)this.inventorySlots).scrollTo(this.currentScroll);
        }
        super.drawScreen(x, y, renderPartialTicks);
        if (x >= this.guiLeft + 115 && y >= this.guiTop + 5 && x < this.guiLeft + 220 && y < this.guiTop + 135) {
            String s = Localization.GUI.PREVIEW.DRAG.translate();
            this.drawHoveringText(Arrays.asList(s.split("\n")), x, y, this.fontRendererObj);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float renderPartialTicks, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.getMinecraft().getTextureManager().bindTexture(texture);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.guiLeft + 101, this.guiTop + 8 + (int)(109.0f * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.sign != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)this.guiLeft + 170.0f), (float)((float)this.guiTop + 70.0f), (float)70.0f);
            float scale = 70.0f;
            GL11.glScalef((float)(-scale), (float)scale, (float)scale);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)this.roll, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            TileEntityRendererDispatcher.instance.renderTileEntityAt((TileEntity)this.sign, -0.5, -0.75, -0.5, 0.0f);
            GL11.glPopMatrix();
            if (this.isSpinning) {
                this.yaw += 0.1f;
                this.roll %= 360.0f;
                if (this.rollDown) {
                    this.roll -= 0.01f;
                    this.roll = this.roll > 5.0f ? (this.roll -= 0.05f) : (this.roll -= 0.01f);
                    if (this.roll < -5.0f) {
                        this.rollDown = false;
                    }
                } else {
                    this.roll += 0.01f;
                    this.roll = this.roll < 15.0f ? (this.roll += 0.05f) : (this.roll += 0.01f);
                    if (this.roll > 22.0f) {
                        this.rollDown = true;
                    }
                }
            }
        }
    }

    protected void drawGuiContainerForegroundLayer(int x, int y) {
        super.drawGuiContainerForegroundLayer(x, y);
        if (this.sign == null) {
            this.fontRendererObj.drawSplitString(Localization.GUI.PREVIEW.CLICK_SIGN.translate(), 120, 10, 70, Colors.LIGHTGRAY.getRGB());
        }
    }

    private boolean needsScrollBars() {
        return ((ContainerPreview)this.inventorySlots).needsScrollBars();
    }

    protected void handleMouseClick(Slot slot, int slotId, int button, int flag) {
        if (slot != null && slot.getHasStack()) {
            ItemStack stack = slot.getStack();
            this.sign = new TileEntityMoarSign();
            String texture = ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound());
            SignInfo info = SignRegistry.get(texture);
            this.sign.setWorldObj((World)FMLClientHandler.instance().getWorldClient());
            this.sign.isMetal = info.isMetal;
            this.sign.setBlockType(info.isMetal ? Blocks.signStandingMetal : Blocks.signStandingWood);
            IChatComponent[] components = new IChatComponent[]{null, new ChatComponentText("\u00a7nThis is some"), new ChatComponentText("\u00a74example \u00a7ltext"), null};
            System.arraycopy(components, 0, this.sign.signText, 0, this.sign.signText.length);
            this.sign.setResourceLocation(texture);
        }
    }

    public void mouseClickMove(int x, int y, int button, long timeSinceClicked) {
        if (this.isDraging && button == 0) {
            int x1 = x - this.guiLeft;
            int y1 = y - this.guiTop;
            this.yaw = this.yaw + (float)x1 - (float)this.scrollX;
            this.roll = this.roll + (float)y1 - (float)this.scrollY;
            this.scrollX = x1;
            this.scrollY = y1;
        }
        super.mouseClickMove(x, y, button, timeSinceClicked);
    }

    public void mouseClicked(int x, int y, int button) throws IOException {
        if (button == 0 && x >= this.guiLeft + 115 && y >= this.guiTop + 5 && x < this.guiLeft + 220 && y < this.guiTop + 135) {
            int x1 = x - this.guiLeft;
            int y1 = y - this.guiTop;
            this.scrollX = x1;
            this.scrollY = y1;
            this.isSpinning = false;
            this.isDraging = true;
        }
        super.mouseClicked(x, y, button);
    }

    public void mouseReleased(int x, int y, int button) {
        if (this.isDraging && button == 0) {
            this.isSpinning = true;
            this.isDraging = false;
        }
        super.mouseReleased(x, y, button);
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = ((ContainerPreview)this.inventorySlots).itemList.size() / 5 - 6;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
            ((ContainerPreview)this.inventorySlots).scrollTo(this.currentScroll);
        }
    }
}

