/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.MaterialRegistry;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.client.interfaces.GuiExchange;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ModItems;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class NEIExchangeUsageHandler
extends TemplateRecipeHandler {
    private static List<ItemStack> getVariationStacks(ArrayList<SignInfo> infos) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (SignInfo info : infos) {
            stacks.add(ModItems.sign.createMoarItemStack(info.material.path + info.itemName, info.isMetal));
        }
        return stacks;
    }

    public String getGuiTexture() {
        return "moarsigns:textures/gui/sign_exchange_nei.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"crafting.moarsigns.sign.exchange");
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiExchange.class;
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)164, (int)118);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient != null && ingredient.func_77973_b() != null && ingredient.func_77973_b() instanceof ItemMoarSign) {
            String texture = ItemMoarSign.getTextureFromNBTFull(ingredient.func_77978_p());
            SignInfo signInfo = SignRegistry.get(texture);
            if (signInfo == null || signInfo.material == null || signInfo.material.materialName == null) {
                return;
            }
            HashSet<MaterialInfo> materials = MaterialRegistry.get(signInfo.material.materialName);
            if (materials == null || materials.size() <= 1) {
                return;
            }
            ArrayList<SignInfo> signs = SignRegistry.getSignInfoFromMaterials(materials);
            if (signs == null || signs.size() <= 1) {
                return;
            }
            List<ItemStack> variations = NEIExchangeUsageHandler.getVariationStacks(signs);
            this.addCached(variations, ingredient);
        }
    }

    private void addCached(List<ItemStack> variations, ItemStack base) {
        this.arecipes.add(new CachedExchangeRecipe(variations, base));
    }

    public class CachedExchangeRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private List<PositionedStack> input;
        private List<PositionedStack> outputs;

        public CachedExchangeRecipe(List<ItemStack> variations, ItemStack base) {
            super((TemplateRecipeHandler)NEIExchangeUsageHandler.this);
            this.input = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            PositionedStack pStack = new PositionedStack(base != null ? base : variations, 75, 13);
            pStack.setMaxSize(1);
            this.input.add(pStack);
            int row = 0;
            int col = 0;
            for (ItemStack v : variations) {
                this.outputs.add(new PositionedStack((Object)v, 3 + 18 * col, 43 + 18 * row));
                if (++col <= 9) continue;
                col = 0;
                ++row;
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIExchangeUsageHandler.this.cycleticks / 20, this.input);
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

