package gory_moon.moarsigns.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMoarSignWall extends BlockMoarSign {

    public static final PropertyDirection FACING = PropertyDirection.func_177714_a("facing");

    public BlockMoarSignWall(Material material, boolean freeStand) {
        super(material, freeStand);
    }

    @Override
    public IBlockState func_176203_a(int meta)
    {
        return this.func_176223_P().func_177226_a(ROTATION, meta);
    }

    @Override
    protected BlockState func_180661_e() {
        return new BlockState(this, ROTATION, FACING);
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int meta = func_176201_c(state);
        boolean flatSign = ((meta & 8) >> 3) == 1;
        int facing = flatSign ? (meta & 1): (meta & 7);
        return state.func_177226_a(FACING, EnumFacing.func_82600_a(facing));
    }

    @Override
    public int func_176201_c(IBlockState state)
    {
        return state.func_177229_b(ROTATION);
    }

    @Override
    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int l = state.func_177230_c().func_176201_c(state);
        float f = 0.28125F;
        float f1 = 0.78125F;
        float f2 = 0.0F;
        float f3 = 1.0F;
        float f4 = 0.125F;
        func_149676_a(0.0F, 0.0F, 0.0F, 1.0F, 1.0F, 1.0F);

        EnumFacing side = EnumFacing.func_82600_a(l & 7);
        boolean flatSign = ((l & 8) >> 3) == 1;
        boolean groundSign;

        if (flatSign) {
            groundSign = (l & 1) == 1;
            int rotation = (l & 6) >> 1;

            if (groundSign) {
                func_149676_a(f2, f2, f - 0.01F, f3, f4, f1 - 0.01F);
                switch (rotation) {
                    case 1:
                        func_149676_a(f - 0.05F, f2, f2, f1 - 0.05F, f4, f3);
                        break;
                    case 2:
                        func_149676_a(f2, f2, f - 0.05F, f3, f4, f1 - 0.05F);
                        break;
                    case 3:
                        func_149676_a(f - 0.01F, f2, f2, f1 - 0.01F, f4, f3);
                }
            } else {
                func_149676_a(f2, f3 - f4, f - 0.05F, f3, f3, f1 - 0.05F);
                switch (rotation) {
                    case 1:
                        func_149676_a(f - 0.01F, f3 - f4, f2, f1 - 0.01F, f3, f3);
                        break;
                    case 2:
                        func_149676_a(f2, f3 - f4, f - 0.01F, f3, f3, f1 - 0.01F);
                        break;
                    case 3:
                        func_149676_a(f - 0.05F, f3 - f4, f2, f1 - 0.05F, f3, f3);
                }
            }
        } else {
            switch (side) {
                case NORTH:
                    func_149676_a(f2, f - 0.01F, f3 - f4, f3, f1 - 0.01F, f3);
                    break;
                case SOUTH:
                    func_149676_a(f2, f - 0.01F, f2, f3, f1 - 0.01F, f4);
                    break;
                case WEST:
                    func_149676_a(f3 - f4, f - 0.01F, f2, f3, f1 - 0.01F, f3);
                    break;
                case EAST:
                    func_149676_a(f2, f - 0.01F, f2, f4, f1 - 0.01F, f3);
            }
        }
    }

    @Override
    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighbor) {
        boolean flag;
        int rotation = world.func_180495_p(pos).func_177229_b(ROTATION);
        EnumFacing facing = EnumFacing.func_82600_a(rotation & 7);


        boolean flatSign = ((rotation & 8) >> 3) == 1;
        boolean groundSign;

        if (flatSign) {
            groundSign = (rotation & 1) == 1;

            if (groundSign) {
                flag = !(world.func_180495_p(pos.func_177977_b()).func_177230_c().func_149688_o().func_76220_a());
            } else {
                flag = !(world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o().func_76220_a());
            }
        } else {

            flag = !(facing == EnumFacing.NORTH && world.func_180495_p(pos.func_177968_d()).func_177230_c().func_149688_o().func_76220_a());

            if (world.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c().func_149688_o().func_76220_a())
                flag = false;
        }

        if (flag) {
            world.func_175698_g(pos);
        }
    }
}
