package gory_moon.moarsigns.blocks;

import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.client.particle.EntityDiggingFXMoarSigns;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.ArrayList;
import java.util.Random;

public class BlockMoarSign extends BlockContainer {

    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a("rotation", 0, 15);

    public BlockMoarSign(Material material, boolean freeStand) {
        super(material);
        func_149663_c("moarsign.sign");
    }

    @Override
    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state)
    {
        return null;
    }

    @SideOnly(Side.CLIENT)
    @Override
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        func_180654_a(world, pos);
        return super.func_180646_a(world, pos);
    }

    @Override
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random random) {
        SignInfo signInfo = getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.randomDisplayTick(world, pos, state, random);
        }
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        SignInfo signInfo = getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.onEntityCollidedWithBlock(world, pos, state, entity);
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        SignInfo signInfo = getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            return signInfo.property.onRightClick(world, pos, state, player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @SideOnly(Side.CLIENT)
    @Override
    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        IBlockState state = world.func_180495_p(pos);
        int i = 4;
        for (int j = 0; j < i; ++j)
        {
            for (int k = 0; k < i; ++k)
            {
                for (int l = 0; l < i; ++l)
                {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5D) / (double)i;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5D) / (double)i;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5D) / (double)i;
                    effectRenderer.func_78873_a((new EntityDiggingFXMoarSigns(world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5D, d1 - (double)pos.func_177956_o() - 0.5D, d2 - (double)pos.func_177952_p() - 0.5D, pos, state)).func_174846_a(pos));
                }
            }
        }

        return true;
    }

    @SideOnly(Side.CLIENT)
    @Override
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        BlockPos pos = target.func_178782_a();
        EnumFacing side = target.field_178784_b;
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();

        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        float f = 0.1F;
        double d0 = (double)i + world.field_73012_v.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0F)) + (double)f + block.func_149704_x();
        double d1 = (double)j + world.field_73012_v.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0F)) + (double)f + block.func_149665_z();
        double d2 = (double)k + world.field_73012_v.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0F)) + (double)f + block.func_149706_B();

        if (side == EnumFacing.DOWN)
        {
            d1 = (double)j + block.func_149665_z() - (double)f;
        }

        if (side == EnumFacing.UP)
        {
            d1 = (double)j + block.func_149669_A() + (double)f;
        }

        if (side == EnumFacing.NORTH)
        {
            d2 = (double)k + block.func_149706_B() - (double)f;
        }

        if (side == EnumFacing.SOUTH)
        {
            d2 = (double)k + block.func_149693_C() + (double)f;
        }

        if (side == EnumFacing.WEST)
        {
            d0 = (double)i + block.func_149704_x() - (double)f;
        }

        if (side == EnumFacing.EAST)
        {
            d0 = (double)i + block.func_149753_y() + (double)f;
        }

        effectRenderer.func_78873_a((new EntityDiggingFXMoarSigns(world, d0, d1, d2, 0.0D, 0.0D, 0.0D, pos, iblockstate)).func_174846_a(pos).func_70543_e(0.2F).func_70541_f(0.6F));
        return true;
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    @Override
    public boolean func_149686_d()
    {
        return false;
    }

    @Override
    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos)
    {
        return true;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityMoarSign();
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityMoarSign tileEntity = (TileEntityMoarSign) world.func_175625_s(pos);
        String s = tileEntity.texture_name;
        s = s != null ? s : "null";
        return ModItems.sign.createMoarItemStack(s, tileEntity.isMetal);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        func_176226_b(world, pos, state, 0);
        super.func_180663_b(world, pos, state);
    }

    @Override
    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {

        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileEntity = (TileEntityMoarSign) entity;
            if (tileEntity.removeNoDrop || tileEntity.texture_name == null) return ret;

            ret.add(ModItems.sign.createMoarItemStack(tileEntity.texture_name, tileEntity.isMetal));
        }
        return ret;
    }

    @Override
    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityMoarSign)
            ((TileEntityMoarSign) entity).removeNoDrop = player.field_71075_bZ.field_75098_d;
        return super.removedByPlayer(world, pos, player, false);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        return !this.func_181087_e(world, pos) && world.func_180495_p(pos).func_177230_c().func_149688_o().func_76220_a();
    }

    public SignInfo getSignInfo(World world, BlockPos pos) {

        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMoarSign) {
            TileEntityMoarSign sign = (TileEntityMoarSign) tileEntity;
            return SignRegistry.get(sign.texture_name);
        }

        return null;
    }
}
