/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.MoarSignsCreativeTab;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignOpenGui;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.PlacedCoord;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemMoarSign
extends Item {
    public ItemMoarSign() {
        this.maxStackSize = 16;
        this.setCreativeTab(MoarSignsCreativeTab.tabMS);
        this.setUnlocalizedName("moarsigns");
        this.hasSubtypes = true;
    }

    public static String getTextureFromNBTFull(NBTTagCompound compound) {
        return compound != null && compound.hasKey("SignTexture") ? compound.getString("SignTexture") : "";
    }

    public static String getTextureFromNBT(NBTTagCompound compound) {
        String texture = ItemMoarSign.getTextureFromNBTFull(compound);
        if (texture.contains("\\")) {
            texture = texture.split("\\\\")[1];
        }
        if (texture.contains("/")) {
            texture = texture.split("/")[1];
        }
        return texture;
    }

    public static SignInfo getInfo(NBTTagCompound compound) {
        String texture = ItemMoarSign.getTextureFromNBTFull(compound);
        return SignRegistry.get(texture);
    }

    public String getUnlocalizedName(ItemStack stack) {
        SignInfo info = SignRegistry.get(ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound()));
        if (info == null) {
            return super.getUnlocalizedName() + ".sign.error";
        }
        return super.getUnlocalizedName() + ".sign." + (info.material.path.equals("") ? "" : info.material.path.replace("/", "") + ".") + ItemMoarSign.getTextureFromNBT(stack.getTagCompound());
    }

    public void registerIcons(IIconRegister register) {
        ArrayList<SignInfo> signRegistry = SignRegistry.getSignRegistry();
        for (SignInfo info : signRegistry) {
            String path = info.material.path;
            String loc = info.isMetal ? "metal/" : "wood/";
            IIcon icon = register.registerIcon(info.modId.toLowerCase() + ":" + loc + (path.equals("") ? "" : path.replace("\\", "/")) + info.itemName);
            MoarSigns.icons.put((path.equals("") ? "" : path) + info.itemName, icon);
        }
    }

    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        this.getSubItemStacks(list);
    }

    public void getSubItemStacks(List list) {
        ArrayList<SignInfo> signRegistry = SignRegistry.getActivatedSignRegistry();
        for (SignInfo info : signRegistry) {
            String path = info.material.path;
            list.add(this.createMoarItemStack(path + info.itemName, info.isMetal));
        }
    }

    public EnumRarity getRarity(ItemStack stack) {
        SignInfo info = SignRegistry.get(ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound()));
        if (info != null) {
            return info.rarity;
        }
        return EnumRarity.common;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        SignInfo info = SignRegistry.get(ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound()));
        if (info == null) {
            return MoarSigns.icons.get("oak_sign");
        }
        String path = info.material.path;
        return MoarSigns.icons.get((path.equals("") ? "" : path) + info.itemName);
    }

    public IIcon getIconIndex(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public ItemStack createMoarItemStack(String signName, boolean isMetal) {
        ItemStack itemStack = new ItemStack((Item)this, 1, isMetal ? 1 : 0);
        NBTTagCompound compound = new NBTTagCompound();
        compound.setString("SignTexture", signName.replace("\\", "/"));
        itemStack.setTagCompound(compound);
        return itemStack;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntityMoarSign tileEntity;
        int rotation;
        if (!world.getBlock(x, y, z).getMaterial().isSolid()) {
            return false;
        }
        PlacedCoord coord = new PlacedCoord(x, y, z, side);
        coord = Utils.calculatePlaceSideCoord(coord);
        x = coord.x;
        y = coord.y;
        z = coord.z;
        if (!player.canPlayerEdit(x, y, z, side, stack) || !Blocks.signStandingWood.canPlaceBlockAt(world, x, y, z) || world.isRemote) {
            return false;
        }
        if (side == 1 && !player.isSneaking()) {
            rotation = MathHelper.floor_double((double)((double)((player.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
            if (stack.getItemDamage() == 0) {
                world.setBlock(x, y, z, Blocks.signStandingWood, rotation, 3);
            } else if (stack.getItemDamage() == 1) {
                world.setBlock(x, y, z, Blocks.signStandingMetal, rotation, 3);
            }
        } else {
            if (side == 0 || side == 1) {
                rotation = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                side += rotation << 1;
                side += 8;
            }
            if (stack.getItemDamage() == 0) {
                world.setBlock(x, y, z, Blocks.signWallWood, side, 3);
            } else if (stack.getItemDamage() == 1) {
                world.setBlock(x, y, z, Blocks.signWallMetal, side, 3);
            }
        }
        if (!player.capabilities.isCreativeMode) {
            --stack.stackSize;
        }
        if ((tileEntity = (TileEntityMoarSign)world.getTileEntity(x, y, z)) != null) {
            String texture = ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound());
            SignInfo info = SignRegistry.get(texture);
            if (info == null) {
                return false;
            }
            tileEntity.isMetal = info.isMetal;
            tileEntity.func_145912_a(player);
            tileEntity.setResourceLocation(texture);
            boolean moving = stack.getTagCompound().hasKey("SignMoving") && stack.getTagCompound().getBoolean("SignMoving");
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSignOpenGui(tileEntity, moving), (EntityPlayerMP)player);
        }
        return true;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean extraInfo) {
        SignInfo info = ItemMoarSign.getInfo(stack.getTagCompound());
        if (info != null) {
            String modName = info.activateTag.equals("activeALL") ? "Minecraft" : info.activateTag;
            list.add(Localization.ITEM.SIGN.MATERIAL_ORIGIN.translate((Object)((Object)Colors.WHITE) + Utils.getModName(modName)));
            if (extraInfo) {
                list.add(Localization.ITEM.SIGN.MATERIAL.translate((Object)((Object)Colors.WHITE) + info.material.materialName));
            }
        } else {
            list.add((Object)((Object)Colors.RED) + Localization.ITEM.SIGN.ERROR.translate(Colors.RED.toString()));
        }
    }
}

