/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import gory_moon.moarsigns.ConfigHandler;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.client.interfaces.GuiHandler;
import gory_moon.moarsigns.integration.IntegrationHandler;
import gory_moon.moarsigns.integration.tweaker.MineTweakerIntegration;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.items.NuggetRegistry;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.proxy.CommonProxy;
import java.util.HashMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="MoarSigns", name="MoarSigns", version="1.2.3", certificateFingerprint="5a57c7d1420cf4c58f53ea2a298ebef8215ede63", dependencies="after:BiomesOPlenty;after:Forestry;after:Nature;after:IC2;after:TConstruct;after:Railcraft;after:ThermalFoundation;after:factorization;after:NotEnoughItems;after:Waila;after:MineTweaker3;")
public class MoarSigns {
    private static final String LINK = "https://raw.githubusercontent.com/GoryMoon/MoarSigns/master/version.json";
    @Mod.Instance(value="MoarSigns")
    public static MoarSigns instance;
    @SidedProxy(clientSide="gory_moon.moarsigns.proxy.ClientProxy", serverSide="gory_moon.moarsigns.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static HashMap<String, IIcon> icons;
    private static HashMap<String, ResourceLocation> textures;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new ConfigHandler(event.getSuggestedConfigurationFile());
        FMLInterModComms.sendRuntimeMessage((Object)"MoarSigns", (String)"VersionChecker", (String)"addVersionCheck", (String)LINK);
        PacketHandler.init();
        NuggetRegistry.init();
        Blocks.init();
        ModItems.init();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.initRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        if (FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"gory_moon.moarsigns.integration.waila.Provider.callbackRegister")) {
            logger.info("Loaded Waila Integration");
        }
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        new IntegrationHandler().setupSigns();
        ModItems.registerRecipes();
        if (Loader.isModLoaded((String)"MineTweaker3")) {
            MineTweakerIntegration.register();
        }
    }

    public ResourceLocation getResourceLocation(String s, boolean isMetal) {
        ResourceLocation location = textures.get(isMetal + s);
        if (location == null) {
            SignInfo info = SignRegistry.get(s);
            if (info == null) {
                return null;
            }
            location = new ResourceLocation(info.modId.toLowerCase(), "textures/signs/" + (isMetal ? "metal/" : "wood/") + s + ".png");
            textures.put(s, location);
        }
        return location;
    }

    static {
        logger = LogManager.getLogger((String)"MoarSigns");
        icons = new HashMap();
        textures = new HashMap();
    }
}

