/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.MaterialRegistry;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignSpecialProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.item.ItemStack;

public class SignRegistry {
    public static final String ALWAYS_ACTIVE_TAG = "activeALL";
    private static ArrayList<SignInfo> signRegistry;
    private static ArrayList<SignInfo> activatedSignRegistry;
    private static HashMap<String, Boolean> activeTags;

    public static SignInfo register(String itemName, SignSpecialProperty property, String materialName, String path, boolean gotNugget, ItemStack materialItemStack, ItemStack materialBlock, String modId) {
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack, materialBlock);
        return SignRegistry.register(itemName, property, info, modId, ALWAYS_ACTIVE_TAG);
    }

    public static SignInfo register(String itemName, SignSpecialProperty property, String materialName, String path, boolean gotNugget, ItemStack materialItemStack, ItemStack materialBlock, String modId, String activateTag) {
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack, materialBlock);
        return SignRegistry.register(itemName, property, info, modId, activateTag);
    }

    public static SignInfo register(String itemName, SignSpecialProperty property, String materialName, String path, boolean gotNugget, ItemStack materialItemStack, String modId) {
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack);
        return SignRegistry.register(itemName, property, info, modId, ALWAYS_ACTIVE_TAG);
    }

    public static SignInfo register(String itemName, SignSpecialProperty property, String materialName, String path, boolean gotNugget, ItemStack materialItemStack, String modId, String activateTag) {
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack);
        return SignRegistry.register(itemName, property, info, modId, activateTag);
    }

    private static SignInfo register(String itemName, SignSpecialProperty property, MaterialInfo material, String modId, String activateTag) {
        if (!MaterialRegistry.contains(material)) {
            MaterialRegistry.register(material);
        }
        SignInfo signInfo = new SignInfo(itemName, material, property, modId, activateTag);
        signRegistry.add(signInfo);
        if (!activeTags.containsKey(activateTag)) {
            activeTags.put(activateTag, false);
        } else if (activeTags.get(activateTag).booleanValue()) {
            activatedSignRegistry.add(signInfo);
        }
        return signInfo;
    }

    public static void activateTag(String tag) {
        activeTags.put(tag, true);
        for (SignInfo info : signRegistry) {
            if (!info.activateTag.equals(tag)) continue;
            activatedSignRegistry.add(info);
        }
    }

    public static void decativateTag(String tag) {
        activeTags.put(tag, false);
        for (SignInfo info : activatedSignRegistry) {
            if (!info.activateTag.equals(tag)) continue;
            activatedSignRegistry.remove(info);
        }
    }

    public static SignInfo get(String s) {
        for (SignInfo info : signRegistry) {
            if (!(info.material.path.replace("\\", "/") + info.itemName).equals(s)) continue;
            return info;
        }
        return null;
    }

    public static ArrayList<SignInfo> getSignInfoFromMaterials(HashSet<MaterialInfo> materials) {
        ArrayList signInfos = Lists.newArrayList();
        block0: for (SignInfo info : activatedSignRegistry) {
            for (MaterialInfo materialInfo : materials) {
                if (!info.material.materialName.equals(materialInfo.materialName)) continue;
                signInfos.add(info);
                continue block0;
            }
        }
        return signInfos;
    }

    public static ArrayList<SignInfo> getSignRegistry() {
        return (ArrayList)signRegistry.clone();
    }

    public static ArrayList<SignInfo> getActivatedSignRegistry() {
        return (ArrayList)activatedSignRegistry.clone();
    }

    public static HashMap<String, Boolean> getActiveTags() {
        return (HashMap)activeTags.clone();
    }

    public static int getActiveTagsAmount() {
        int i = 0;
        for (boolean b : activeTags.values()) {
            if (!b) continue;
            ++i;
        }
        return i;
    }

    static {
        activeTags = Maps.newHashMap();
        signRegistry = Lists.newArrayList();
        activatedSignRegistry = Lists.newArrayList();
        SignRegistry.activateTag(ALWAYS_ACTIVE_TAG);
    }
}

