/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.tweaker;

import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.ShapedMoarSignRecipe;
import gory_moon.moarsigns.api.ShapelessMoarSignRecipe;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.integration.tweaker.MatchTypeEntry;
import gory_moon.moarsigns.integration.tweaker.MaterialEntry;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ModItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.mc1710.item.MCItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.MoarSigns")
public class Signs {
    private static List<ItemStack> signs = new ArrayList<ItemStack>();

    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(false, Signs.toStack(output), Signs.toShapedObjects(ingredients)));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(true, Signs.toStack(output), Signs.toObjects(ingredients)));
    }

    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(Signs.toStack(output)));
    }

    @ZenMethod
    public static IItemStack[] getSigns(IIngredient ingredient) {
        IItemStack[] base = new IItemStack[]{};
        if (ingredient instanceof MatchTypeEntry || ingredient instanceof MaterialEntry) {
            if (signs.isEmpty()) {
                ModItems.sign.getSubItemStacks(signs);
            }
            ArrayList<MCItemStack> signs = new ArrayList<MCItemStack>();
            if (ingredient instanceof MatchTypeEntry) {
                for (ItemStack stack : Signs.signs) {
                    SignInfo info = ItemMoarSign.getInfo(stack.getTagCompound());
                    if (ingredient.getInternal() == ShapedMoarSignRecipe.MatchType.ALL) {
                        signs.add(new MCItemStack(stack));
                        continue;
                    }
                    if (ingredient.getInternal() == ShapedMoarSignRecipe.MatchType.METAL && info.isMetal) {
                        signs.add(new MCItemStack(stack));
                        continue;
                    }
                    if (ingredient.getInternal() != ShapedMoarSignRecipe.MatchType.WOOD || info.isMetal) continue;
                    signs.add(new MCItemStack(stack));
                }
            } else {
                for (ItemStack stack : Signs.signs) {
                    SignInfo info = ItemMoarSign.getInfo(stack.getTagCompound());
                    if (!((MaterialInfo)ingredient.getInternal()).materialName.equals(info.material.materialName)) continue;
                    signs.add(new MCItemStack(stack));
                }
            }
            return signs.toArray(base);
        }
        return Collections.emptyList().toArray(base);
    }

    @ZenMethod
    public static IItemStack getFirstSign(IIngredient ingredient) {
        IItemStack[] signs = Signs.getSigns(ingredient);
        if (signs != null && signs.length > 0) {
            return signs[0];
        }
        return null;
    }

    public static ItemStack toStack(IItemStack iStack) {
        return MineTweakerMC.getItemStack((IItemStack)iStack);
    }

    public static ItemStack[] toStacks(IItemStack[] iStack) {
        if (iStack == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[iStack.length];
        for (int i = 0; i < iStack.length; ++i) {
            output[i] = Signs.toStack(iStack[i]);
        }
        return output;
    }

    public static Object toObject(IIngredient iStack) {
        if (iStack == null) {
            return null;
        }
        if (iStack instanceof IOreDictEntry) {
            return Signs.toString((IOreDictEntry)iStack);
        }
        if (iStack instanceof IItemStack) {
            return Signs.toStack((IItemStack)iStack);
        }
        if (iStack instanceof MatchTypeEntry) {
            return (ShapedMoarSignRecipe.MatchType)((Object)iStack.getInternal());
        }
        if (iStack instanceof MaterialEntry) {
            return (MaterialInfo)iStack.getInternal();
        }
        return null;
    }

    public static Object[] toObjects(IIngredient[] ingredient) {
        if (ingredient == null) {
            return null;
        }
        Object[] output = new Object[ingredient.length];
        for (int i = 0; i < ingredient.length; ++i) {
            output[i] = ingredient[i] != null ? Signs.toObject(ingredient[i]) : "";
        }
        return output;
    }

    public static Object[] toShapedObjects(IIngredient[][] ingredients) {
        if (ingredients == null) {
            return null;
        }
        ArrayList<Object> prep = new ArrayList<Object>();
        prep.add("abc");
        prep.add("def");
        prep.add("ghi");
        char[][] map = new char[][]{{'a', 'b', 'c'}, {'d', 'e', 'f'}, {'g', 'h', 'i'}};
        for (int x = 0; x < ingredients.length; ++x) {
            if (ingredients[x] == null) continue;
            for (int y = 0; y < ingredients[x].length; ++y) {
                if (ingredients[x][y] == null || x >= map.length || y >= map[x].length) continue;
                prep.add(Character.valueOf(map[x][y]));
                prep.add(Signs.toObject(ingredients[x][y]));
            }
        }
        return prep.toArray();
    }

    public static String toString(IOreDictEntry entry) {
        return entry.getName();
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        private IRecipe iRecipe;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            List allRecipes = CraftingManager.getInstance().getRecipeList();
            for (IRecipe recipe : allRecipes) {
                if (!(recipe instanceof ShapedMoarSignRecipe) && !(recipe instanceof ShapelessMoarSignRecipe) || recipe.getRecipeOutput() == null || !ItemStack.areItemStacksEqual((ItemStack)recipe.getRecipeOutput(), (ItemStack)this.output)) continue;
                this.iRecipe = recipe;
                break;
            }
            CraftingManager.getInstance().getRecipeList().remove(this.iRecipe);
        }

        public boolean canUndo() {
            return CraftingManager.getInstance().getRecipeList() != null && this.iRecipe != null;
        }

        public void undo() {
            CraftingManager.getInstance().getRecipeList().add(this.iRecipe);
        }

        public String describe() {
            return "Removing MoarSign recipe for " + this.output.getDisplayName();
        }

        public String describeUndo() {
            return "Restoring MoarSign recipe for " + this.output.getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final boolean isShapeless;
        private final ItemStack output;
        private final Object[] recipe;
        private IRecipe iRecipe;

        public Add(boolean isShapeless, ItemStack output, Object ... recipe) {
            this.isShapeless = isShapeless;
            this.output = output;
            this.recipe = recipe;
        }

        public void apply() {
            this.iRecipe = this.isShapeless ? new ShapelessMoarSignRecipe(this.output, true, this.recipe) : new ShapedMoarSignRecipe(this.output, this.recipe);
            CraftingManager.getInstance().getRecipeList().add(this.iRecipe);
        }

        public boolean canUndo() {
            return CraftingManager.getInstance().getRecipeList() != null;
        }

        public void undo() {
            CraftingManager.getInstance().getRecipeList().remove(this.iRecipe);
        }

        public String describe() {
            return "Adding MoarSign recipe for " + this.output.getDisplayName();
        }

        public String describeUndo() {
            return "Removing MoarSign recipe for " + this.output.getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

