/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.interfaces.buttons;

import gory_moon.moarsigns.client.interfaces.GuiBase;
import gory_moon.moarsigns.client.interfaces.GuiMoarSign;
import gory_moon.moarsigns.client.interfaces.buttons.GuiButton;
import gory_moon.moarsigns.client.interfaces.buttons.GuiButtonSpecial;
import gory_moon.moarsigns.util.Localization;
import java.util.ArrayList;

public class ButtonTextShadow
extends GuiButtonSpecial {
    private int id;
    private boolean hasShadow;

    public ButtonTextShadow(int id, int x, int y, boolean hasShadow) {
        super(x, y, 16, 16, hasShadow ? 224 : 240, 120);
        this.id = id;
        this.hasShadow = hasShadow;
    }

    @Override
    public void drawButton(GuiBase gui, int mouseX, int mouseY) {
        int srcX;
        int n = srcX = this.hasShadow ? 224 : 240;
        int buttonType = this.isDisabled ? this.srcY + this.h * 2 : (this.inRect(mouseX, mouseY) ? this.srcY + this.h : this.srcY);
        super.draw(gui, srcX, buttonType);
    }

    @Override
    public String getButtonInfo(GuiBase gui) {
        return Localization.GUI.BUTTONS.TEXT_SHADOW.translateTitles(this.hasShadow ? "1" : "0") + this.newLine + Localization.GUI.BUTTONS.TEXT_SHADOW.translateDescriptions(this.hasShadow ? "1" : "0");
    }

    @Override
    public void action(GuiBase gui) {
        GuiMoarSign guiM = (GuiMoarSign)gui;
        this.setShadow(gui, !this.hasShadow);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (guiM.buttonLock.getState()) {
            for (GuiButton next : guiM.textButtons) {
                int nextID;
                if (!(next instanceof ButtonTextShadow) || ids.contains(nextID = ((ButtonTextShadow)next).id)) continue;
                ids.add(nextID);
                ((ButtonTextShadow)next).setShadow(gui, this.hasShadow);
            }
        }
    }

    public void setShadow(GuiBase gui, boolean shadow) {
        GuiMoarSign guiM = (GuiMoarSign)gui;
        guiM.shadowRows[this.id] = this.hasShadow = shadow;
    }
}

