/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network.message;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gory_moon.moarsigns.blocks.BlockMoarSign;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;

public class MessageSignRotate
implements IMessage,
IMessageHandler<MessageSignRotate, IMessage> {
    int x;
    int y;
    int z;
    int meta;
    String texture;

    public MessageSignRotate() {
    }

    public MessageSignRotate(int x, int y, int z, int meta, String texture) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.meta = meta;
        this.texture = texture;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.meta = buf.readInt();
        int textureLength = buf.readInt();
        this.texture = new String(buf.readBytes(textureLength).array());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.meta);
        buf.writeInt(this.texture.length());
        buf.writeBytes(this.texture.getBytes());
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageSignRotate message, MessageContext ctx) {
        WorldClient world = FMLClientHandler.instance().getClient().theWorld;
        Block block = world.getBlock(message.x, message.y, message.z);
        if (block instanceof BlockMoarSign) {
            TileEntityMoarSign sign = (TileEntityMoarSign)world.getTileEntity(message.x, message.y, message.z);
            sign.blockMetadata = message.meta;
            sign.setResourceLocation(message.texture);
        }
        return null;
    }
}

