/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.MaterialRegistry;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignSpecialProperty;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;

public class SignRegistry {
    public static final String ALWAYS_ACTIVE_TAG = "activeALL";
    private static List<SignInfo> signRegistry;
    private static List<SignInfo> activatedSignRegistry;
    private static HashMap<String, Boolean> activeTags;

    public static SignInfo register(String itemName, SignSpecialProperty property, String materialName, String path, boolean gotNugget, ItemStack materialItemStack, String modId) {
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack);
        return SignRegistry.register(itemName, property, info, modId, ALWAYS_ACTIVE_TAG);
    }

    public static SignInfo register(String itemName, SignSpecialProperty property, String materialName, String path, boolean gotNugget, ItemStack materialItemStack, String modId, String activateTag) {
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack);
        return SignRegistry.register(itemName, property, info, modId, activateTag);
    }

    private static SignInfo register(String itemName, SignSpecialProperty property, MaterialInfo material, String modId, String activateTag) {
        if (!MaterialRegistry.contains(material)) {
            MaterialRegistry.register(material);
        }
        SignInfo signInfo = new SignInfo(itemName, material, property, modId, activateTag);
        signRegistry.add(signInfo);
        if (!activeTags.containsKey(activateTag)) {
            activeTags.put(activateTag, false);
        } else if (activeTags.get(activateTag).booleanValue()) {
            activatedSignRegistry.add(signInfo);
        }
        return signInfo;
    }

    public static void activateTag(String tag) {
        activeTags.put(tag, true);
        for (SignInfo info : signRegistry) {
            if (!info.activateTag.equals(tag)) continue;
            activatedSignRegistry.add(info);
        }
    }

    public static void decativateTag(String tag) {
        activeTags.put(tag, false);
        for (SignInfo info : activatedSignRegistry) {
            if (!info.activateTag.equals(tag)) continue;
            activatedSignRegistry.remove(info);
        }
    }

    public static SignInfo get(String s) {
        for (SignInfo info : signRegistry) {
            if (!(info.material.path.replace("\\", "/") + info.itemName).equals(s)) continue;
            return info;
        }
        return null;
    }

    public static List<SignInfo> getSignRegistry() {
        return signRegistry;
    }

    public static List<SignInfo> getActivatedSignRegistry() {
        return activatedSignRegistry;
    }

    static {
        activeTags = Maps.newHashMap();
        signRegistry = Lists.newArrayList();
        activatedSignRegistry = Lists.newArrayList();
        SignRegistry.activateTag(ALWAYS_ACTIVE_TAG);
    }
}

