/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network.message;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.client.interfaces.GuiMoarSign;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class MessageSignMainInfo
implements IMessage,
IMessageHandler<MessageSignMainInfo, IMessage> {
    public int x;
    public int y;
    public int z;
    public String texture;
    public boolean isMetal;
    public int fontSize;
    public int offset;
    public String[] text = new String[]{"", "", "", ""};
    public boolean openGui;

    public MessageSignMainInfo() {
    }

    public MessageSignMainInfo(int x, int y, int z, String texture, boolean isMetal, int fontSize, int offset, String[] text, boolean openGui) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.texture = texture;
        this.isMetal = isMetal;
        this.fontSize = fontSize;
        this.offset = offset;
        this.text = text;
        this.openGui = openGui;
    }

    public MessageSignMainInfo(TileEntityMoarSign tileEntity, boolean openGui) {
        this(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity.texture_name, tileEntity.isMetal, tileEntity.fontSize, tileEntity.textOffset, tileEntity.field_145915_a, openGui);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        int textureLength = buf.readInt();
        this.texture = new String(buf.readBytes(textureLength).array());
        this.isMetal = buf.readBoolean();
        this.fontSize = buf.readInt();
        this.offset = buf.readInt();
        for (int i = 0; i < 4; ++i) {
            int textLength = buf.readInt();
            this.text[i] = new String(buf.readBytes(textLength).array());
        }
        this.openGui = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.texture.length());
        buf.writeBytes(this.texture.getBytes());
        buf.writeBoolean(this.isMetal);
        buf.writeInt(this.fontSize);
        buf.writeInt(this.offset);
        for (int i = 0; i < 4; ++i) {
            buf.writeInt(this.text[i].length());
            buf.writeBytes(this.text[i].getBytes());
        }
        buf.writeBoolean(this.openGui);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageSignMainInfo message, MessageContext ctx) {
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        Object tileEntity = null;
        if (message.openGui && world.func_72899_e(message.x, message.y, message.z) && (tileEntity = world.func_147438_o(message.x, message.y, message.z)) == null) {
            tileEntity = new TileEntityMoarSign();
            tileEntity.func_145834_a((World)FMLClientHandler.instance().getClient().field_71441_e);
            tileEntity.field_145851_c = message.x;
            tileEntity.field_145848_d = message.y;
            tileEntity.field_145849_e = message.z;
        }
        boolean flag = false;
        if (world.func_72899_e(message.x, message.y, message.z)) {
            if (!message.openGui) {
                tileEntity = world.func_147438_o(message.x, message.y, message.z);
            }
            if (tileEntity instanceof TileEntityMoarSign) {
                TileEntityMoarSign sign = (TileEntityMoarSign)((Object)tileEntity);
                sign.isMetal = message.isMetal;
                sign.fontSize = message.fontSize;
                sign.textOffset = message.offset;
                sign.setResourceLocation(message.texture);
                if (sign.isEditable()) {
                    System.arraycopy(message.text, 0, sign.field_145915_a, 0, 4);
                    if (!message.openGui) {
                        sign.func_70296_d();
                    }
                }
                flag = true;
            }
        }
        if (!flag && FMLClientHandler.instance().getClient().field_71439_g != null) {
            MoarSigns.logger.info("Unable to locate sign at " + message.x + ", " + message.y + ", " + message.z);
            FMLClientHandler.instance().getClient().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Unable to locate sign at " + message.x + ", " + message.y + ", " + message.z));
        }
        if (message.openGui && tileEntity instanceof TileEntityMoarSign) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiMoarSign((TileEntityMoarSign)((Object)tileEntity)));
        }
        return null;
    }
}

