/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.renderers;

import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.client.ModelMoarSign;
import gory_moon.moarsigns.lib.Info;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MoarSignRenderer
extends TileEntitySpecialRenderer {
    private ModelMoarSign modelMoarSign;
    private ResourceLocation texture;
    private ResourceLocation tempTexture = new ResourceLocation("textures/entity/sign.png");

    public MoarSignRenderer() {
        this.modelMoarSign = new ModelMoarSign();
    }

    public void renderTileEntityMoarSignAt(TileEntityMoarSign tileentity, double x, double y, double z, float partialTickTime) {
        float f2;
        this.texture = tileentity.getResourceLocation();
        Block block = tileentity.func_145838_q();
        GL11.glPushMatrix();
        float f1 = 0.6666667f;
        if (block == Blocks.signStandingWood || block == Blocks.signStandingMetal) {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f * f1), (float)((float)z + 0.5f));
            float f3 = (float)(tileentity.func_145832_p() * 360) / 16.0f;
            GL11.glRotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelMoarSign.stick.field_78806_j = true;
        } else {
            int i = tileentity.func_145832_p();
            int side = i & 7;
            f2 = 0.0f;
            boolean flatSign = (i & 8) >> 3 == 1;
            boolean groundSign = false;
            if (flatSign) {
                int rotation;
                boolean bl = groundSign = (i & 1) == 1;
                if (groundSign) {
                    rotation = (i & 6) >> 1;
                    f2 = 0.0f;
                    if (rotation == 1) {
                        f2 = 90.0f;
                    } else if (rotation == 2) {
                        f2 = 180.0f;
                    } else if (rotation == 3) {
                        f2 = -90.0f;
                    }
                } else {
                    rotation = (i & 6) >> 1;
                    f2 = 180.0f;
                    if (rotation == 1) {
                        f2 = -90.0f;
                    } else if (rotation == 2) {
                        f2 = 0.0f;
                    } else if (rotation == 3) {
                        f2 = 90.0f;
                    }
                }
            } else {
                if (side == 2) {
                    f2 = 180.0f;
                }
                if (side == 4) {
                    f2 = 90.0f;
                }
                if (side == 5) {
                    f2 = -90.0f;
                }
            }
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f * f1), (float)((float)z + 0.5f));
            GL11.glRotatef((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
            if (flatSign && !groundSign) {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (flatSign && groundSign) {
                GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.4375f);
            this.modelMoarSign.stick.field_78806_j = false;
        }
        if (this.texture != null) {
            this.func_147499_a(this.texture);
        } else {
            this.func_147499_a(this.tempTexture);
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)f1, (float)(-f1), (float)(-f1));
        this.modelMoarSign.render();
        GL11.glPopMatrix();
        FontRenderer fontRenderer = this.func_147498_b();
        float size = tileentity.fontSize;
        f2 = 0.016666668f * f1 + size / 1000.0f;
        GL11.glTranslatef((float)(size > 0.0f ? 0.01f : 0.0f), (float)(0.5f * f1 - 0.02f * size), (float)(0.07f * f1));
        GL11.glScalef((float)f2, (float)(-f2), (float)f2);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * f2));
        GL11.glDepthMask((boolean)false);
        int rows = Utils.getRows((int)size);
        int maxLength = Utils.getMaxLength((int)size);
        int offset = tileentity.textOffset;
        int[] row = Info.textPostion[(int)size];
        int lastRow = row[0];
        if (row.length > 1 && offset > lastRow) {
            for (int i = 0; i < row.length; ++i) {
                if (offset >= row[i]) continue;
                rows = i;
                break;
            }
        } else {
            rows = 1;
            offset = tileentity.textOffset < lastRow ? lastRow : tileentity.textOffset;
        }
        for (int j = 0; j < rows; ++j) {
            String s = fontRenderer.func_78269_a(tileentity.field_145915_a[j], Math.min(maxLength, fontRenderer.func_78256_a(tileentity.field_145915_a[j])));
            if (j == tileentity.field_145918_i) {
                s = "> " + s + " <";
            }
            fontRenderer.func_78276_b(s, -fontRenderer.func_78256_a(s) / 2, j * 10 - tileentity.field_145915_a.length * 5 - offset - (size > 12.0f ? 0 : (size > 0.0f ? 1 : 2)), 0);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float partialTickTime) {
        this.renderTileEntityMoarSignAt((TileEntityMoarSign)tileentity, x, y, z, partialTickTime);
    }
}

