/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network.message;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.network.ServerMessageHandler;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSignInfo
implements IMessage {
    public BlockPos pos;
    public String texture;
    public boolean isMetal;
    public int[] rowLocations = new int[4];
    public int[] rowSizes = new int[]{0, 0, 0, 0};
    public boolean[] visibleRows = new boolean[]{true, true, true, true};
    public boolean[] shadowRows = new boolean[4];
    public boolean lockedChanges;
    public ITextComponent[] text;

    public MessageSignInfo() {
    }

    public MessageSignInfo(BlockPos pos, String texture, boolean isMetal, int[] rowLocations, int[] rowSizes, boolean[] visibleRows, boolean[] shadowRows, boolean lockedChanges, ITextComponent[] text) {
        this.pos = pos;
        this.texture = texture;
        this.isMetal = isMetal;
        this.rowLocations = rowLocations;
        this.rowSizes = rowSizes;
        this.visibleRows = visibleRows;
        this.shadowRows = shadowRows;
        this.lockedChanges = lockedChanges;
        this.text = text;
    }

    public MessageSignInfo(TileEntityMoarSign tileEntity) {
        this(tileEntity.func_174877_v(), tileEntity.texture_name, tileEntity.isMetal, tileEntity.rowLocations, tileEntity.rowSizes, tileEntity.visibleRows, tileEntity.shadowRows, tileEntity.lockedChanges, tileEntity.field_145915_a);
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        this.pos = packetBuf.func_179259_c();
        this.text = new ITextComponent[4];
        if (packetBuf.readBoolean()) {
            int i;
            this.texture = packetBuf.func_150789_c(Short.MAX_VALUE);
            this.isMetal = packetBuf.readBoolean();
            for (i = 0; i < 4; ++i) {
                this.rowLocations[i] = packetBuf.readInt();
            }
            for (i = 0; i < 4; ++i) {
                this.rowSizes[i] = packetBuf.readInt();
            }
            for (i = 0; i < 4; ++i) {
                this.visibleRows[i] = packetBuf.readBoolean();
            }
            for (i = 0; i < 4; ++i) {
                this.shadowRows[i] = packetBuf.readBoolean();
            }
            this.lockedChanges = packetBuf.readBoolean();
            for (i = 0; i < 4; ++i) {
                try {
                    this.text[i] = packetBuf.func_179258_d();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        packetBuf.func_179255_a(this.pos);
        if (this.texture != null && this.rowLocations != null && this.rowSizes != null && this.visibleRows != null && this.text != null) {
            int i;
            packetBuf.writeBoolean(true);
            packetBuf.func_180714_a(this.texture);
            packetBuf.writeBoolean(this.isMetal);
            for (i = 0; i < 4; ++i) {
                packetBuf.writeInt(this.rowLocations[i]);
            }
            for (i = 0; i < 4; ++i) {
                packetBuf.writeInt(this.rowSizes[i]);
            }
            for (i = 0; i < 4; ++i) {
                packetBuf.writeBoolean(this.visibleRows[i]);
            }
            for (i = 0; i < 4; ++i) {
                packetBuf.writeBoolean(this.shadowRows[i]);
            }
            packetBuf.writeBoolean(this.lockedChanges);
            for (i = 0; i < 4; ++i) {
                packetBuf.func_179256_a(this.text[i]);
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public static class ServerHandler
    extends ServerMessageHandler<MessageSignInfo> {
        @Override
        protected void handle(MessageSignInfo message, MessageContext ctx) {
            TileEntity tileentity;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_143004_u();
            WorldServer worldserver = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(player.field_71093_bK);
            BlockPos pos = message.pos;
            if (worldserver.func_175667_e(pos) && (tileentity = worldserver.func_175625_s(pos)) instanceof TileEntityMoarSign) {
                TileEntityMoarSign sign = (TileEntityMoarSign)tileentity;
                if (!sign.func_145914_a() || sign.func_145911_b() != player) {
                    MoarSigns.logger.warn("Player " + player.func_70005_c_() + " just tried to change non-editable sign");
                    return;
                }
                sign.isMetal = message.isMetal;
                sign.rowLocations = message.rowLocations;
                sign.rowSizes = message.rowSizes;
                sign.visibleRows = message.visibleRows;
                sign.shadowRows = message.shadowRows;
                sign.lockedChanges = message.lockedChanges;
                System.arraycopy(message.text, 0, sign.field_145915_a, 0, 4);
                sign.func_70296_d();
                IBlockState iblockstate = worldserver.func_180495_p(pos);
                worldserver.func_184138_a(pos, iblockstate, iblockstate, 3);
            }
        }
    }
}

