/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nonnull;

public class NuggetRegistry {
    private static HashMap<String, NuggetInfo> nuggets = Maps.newHashMap();
    private static HashMap<Integer, String> idMap = Maps.newHashMap();

    public static void init() {
        NuggetRegistry.registerNugget(1, "diamond_nugget", "nuggetDiamond", "", "item.diamond", true);
        NuggetRegistry.registerNugget(2, "emerald_nugget", "nuggetEmerald", "", "item.emerald", true);
        NuggetRegistry.registerNugget(3, "lapis_nugget", "nuggetLapis", "", "item.dyePowder.blue", true);
        NuggetRegistry.registerNugget(4, "quartz_nugget", "nuggetQuartz", "", "item.netherquartz", true);
        NuggetRegistry.registerNugget(5, "bronze_nugget_ic2", "nuggetBronze", "ic2/", "ic2.ingot.bronze");
        NuggetRegistry.registerNugget(6, "copper_nugget_ic2", "nuggetCopper", "ic2/", "ic2.ingot.copper");
        NuggetRegistry.registerNugget(7, "tin_nugget_ic2", "nuggetTin", "ic2/", "ic2.ingot.tin");
        NuggetRegistry.registerNugget(8, "steel_nugget_ic2", "nuggetSteel", "ic2/", "ic2.ingot.steel");
        NuggetRegistry.registerNugget(9, "lead_nugget_ic2", "nuggetLead", "ic2/", "ic2.ingot.lead");
        NuggetRegistry.registerNugget(10, "tin_nugget_forestry", "nuggetTin", "for/", "item.for.ingot_tin");
        NuggetRegistry.registerNugget(11, "bronze_nugget_forestry", "nuggetBronze", "for/", "item.for.ingot_bronze");
        NuggetRegistry.registerNugget(12, "copper_nugget_forestry", "nuggetCopper", "for/", "item.for.ingot_copper");
        NuggetRegistry.registerNugget(13, "silver_nugget_factorization", "nuggetSilver", "factorization/", "item.factorization:silver_ingot");
        NuggetRegistry.registerNugget(14, "lead_nugget_factorization", "nuggetLead", "factorization/", "item.factorization:lead_ingot");
        NuggetRegistry.registerNugget(15, "darkiron_nugget_factorization", "nuggetFzDarkIron", "factorization/", "item.factorization:dark_iron_ingot");
        NuggetRegistry.registerNugget(16, "psimetal_nugget_psi", "nuggetPsiMetal", "psi/", "item.psi:psimetal");
        NuggetRegistry.registerNugget(17, "psigem_nugget_psi", "nuggetPsiGem", "psi/", "item.psi:psigem");
        NuggetRegistry.registerNugget(18, "ebonypsimetal_nugget_psi", "nuggetEbonyPsiMetal", "psi/", "item.psi:ebony_psimetal");
        NuggetRegistry.registerNugget(19, "ivorypsimetal_nugget_psi", "nuggetIvoryPsiMetal", "psi/", "item.psi:ivory_psimetal");
        NuggetRegistry.registerNugget(20, "yellorium_nugget_bigreactors", "nuggetYellorium", "bigreactors/", "item.bigreactors:ingotmetals.yellorium");
        NuggetRegistry.registerNugget(21, "cyanite_nugget_bigreactors", "nuggetCyanite", "bigreactors/", "item.bigreactors:ingotmetals.cyanite");
        NuggetRegistry.registerNugget(22, "graphite_nugget_bigreactors", "nuggetGraphite", "bigreactors/", "item.bigreactors:ingotmetals.graphite");
        NuggetRegistry.registerNugget(23, "blutonium_nugget_bigreactors", "nuggetBlutonium", "bigreactors/", "item.bigreactors:ingotmetals.blutonium");
        NuggetRegistry.registerNugget(24, "ludicrite_nugget_bigreactors", "nuggetLudicrite", "bigreactors/", "item.bigreactors:ingotmetals.ludicrite");
        NuggetRegistry.registerNugget(25, "steel_nugget_bigreactors", "nuggetSteel", "bigreactors/", "item.bigreactors:ingotmetals.steel");
        NuggetRegistry.registerNugget(26, "electricalsteel_nugget_enderio", "nuggetElectricalSteel", "enderio/", "enderio.electricalSteel");
        NuggetRegistry.registerNugget(27, "energeticalloy_nugget_enderio", "nuggetEnergeticAlloy", "enderio/", "enderio.energeticAlloy");
        NuggetRegistry.registerNugget(28, "redstonealloy_nugget_enderio", "nuggetRedstoneAlloy", "enderio/", "enderio.redstoneAlloy");
        NuggetRegistry.registerNugget(29, "conductiveiron_nugget_enderio", "nuggetConductiveIron", "enderio/", "enderio.conductiveIron");
        NuggetRegistry.registerNugget(30, "darksteel_nugget_enderio", "nuggetDarkSteel", "enderio/", "enderio.darkSteel");
        NuggetRegistry.registerNugget(31, "soularium_nugget_enderio", "nuggetSoularium", "enderio/", "enderio.soularium");
    }

    public static void registerNugget(int id, String regName, String oreName, String modId, String ingotName, boolean needed) {
        nuggets.put(ingotName, new NuggetInfo(id, regName, oreName, modId, ingotName, needed));
        idMap.put(id, ingotName);
    }

    public static void registerNugget(int id, String regName, String oreName, String modId, String ingotName) {
        NuggetRegistry.registerNugget(id, regName, oreName, modId, ingotName, false);
    }

    public static HashMap<String, NuggetInfo> getNuggets() {
        return nuggets;
    }

    public static String getUnlocName(int i) {
        return idMap.get(i) != null && nuggets.get(idMap.get(i)) != null ? NuggetRegistry.nuggets.get((Object)NuggetRegistry.idMap.get((Object)Integer.valueOf((int)i))).regName : "error_" + i;
    }

    public static NuggetInfo getNuggetInfo(String ingotName) {
        return nuggets.get(ingotName);
    }

    public static class NuggetInfo
    implements Comparable<NuggetInfo> {
        public String modId;
        public String regName;
        public String oreName;
        public String ingotName;
        public boolean needed;
        public int id;

        public NuggetInfo(int id, String regName, String oreName, String modId, String ingotName, boolean needed) {
            this.id = id;
            this.regName = regName;
            this.oreName = oreName;
            this.modId = modId;
            this.ingotName = ingotName;
            this.needed = needed;
        }

        @Override
        public int compareTo(@Nonnull NuggetInfo o) {
            return Integer.compare(this.id, o.id);
        }
    }
}

