/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import gory_moon.moarsigns.MoarSignsCreativeTab;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.BlockMoarSign;
import gory_moon.moarsigns.blocks.ModBlocks;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignOpenGui;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemMoarSign
extends Item {
    public ItemMoarSign() {
        this.field_77777_bU = 16;
        this.func_77637_a(MoarSignsCreativeTab.tabMS);
        this.setRegistryName("moar_sign");
        this.func_77655_b("moarsigns");
        this.field_77787_bX = true;
    }

    public static String getTextureFromNBTFull(NBTTagCompound compound) {
        return compound != null && compound.func_74764_b("SignTexture") ? compound.func_74779_i("SignTexture") : "";
    }

    public static String getTextureFromNBT(NBTTagCompound compound) {
        String texture = ItemMoarSign.getTextureFromNBTFull(compound);
        if (texture.contains("\\")) {
            texture = texture.split("\\\\")[1];
        }
        if (texture.contains("/")) {
            texture = texture.split("/")[1];
        }
        return texture;
    }

    public static SignInfo getInfo(NBTTagCompound compound) {
        String texture = ItemMoarSign.getTextureFromNBTFull(compound);
        return SignRegistry.get(texture);
    }

    public String func_77667_c(ItemStack stack) {
        SignInfo info = SignRegistry.get(ItemMoarSign.getTextureFromNBTFull(stack.func_77978_p()));
        if (info == null) {
            return super.func_77658_a() + ".sign.error";
        }
        return super.func_77658_a() + ".sign." + (info.material.path.equals("") ? "" : info.material.path.replace("/", "") + ".") + ItemMoarSign.getTextureFromNBT(stack.func_77978_p());
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            this.getSubItemStacks((List)items);
        }
    }

    public void getSubItemStacks(List list) {
        ArrayList<SignInfo> signRegistry = SignRegistry.getActivatedSignRegistry();
        for (SignInfo info : signRegistry) {
            list.add(this.createMoarItemStack(info.material.path + info.itemName, info.isMetal));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        SignInfo info = SignRegistry.get(ItemMoarSign.getTextureFromNBTFull(stack.func_77978_p()));
        if (info != null) {
            return info.rarity;
        }
        return EnumRarity.COMMON;
    }

    public ItemStack createMoarItemStack(String signName, boolean isMetal) {
        ItemStack itemStack = new ItemStack((Item)this, 1, isMetal ? 1 : 0);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("SignTexture", signName.replace("\\", "/"));
        itemStack.func_77982_d(compound);
        return itemStack;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        SignInfo info;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.func_180495_p(pos).func_185904_a().func_76220_a()) {
            return EnumActionResult.PASS;
        }
        if (!player.func_175151_a(pos = pos.func_177972_a(facing), facing, stack) || !ModBlocks.SIGN_STANDING_WOOD.func_176196_c(world, pos)) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        if (stack.func_77973_b() instanceof ItemSignToolbox) {
            NBTTagCompound toolbox = stack.func_77978_p();
            String texture = toolbox.func_74779_i("texture");
            boolean isMetal = toolbox.func_74767_n("isMetal");
            stack = ModItems.SIGN.createMoarItemStack(texture, isMetal);
            stack.func_77978_p().func_74757_a("SignMoving", true);
        }
        if ((info = ItemMoarSign.getInfo(stack.func_77978_p())) == null) {
            return EnumActionResult.PASS;
        }
        if (facing == EnumFacing.UP && !player.func_70093_af()) {
            int rotation = MathHelper.func_76128_c((double)((double)((player.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
            if (!info.isMetal) {
                world.func_180501_a(pos, ModBlocks.SIGN_STANDING_WOOD.func_176223_P().func_177226_a((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(rotation)), 3);
            } else {
                world.func_180501_a(pos, ModBlocks.SIGN_STANDING_METAL.func_176223_P().func_177226_a((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(rotation)), 3);
            }
        } else {
            int finalRotation = facing.func_176745_a();
            if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                int rotation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                finalRotation += rotation << 1;
                finalRotation += 8;
            }
            if (!info.isMetal) {
                world.func_180501_a(pos, ModBlocks.SIGN_WALL_WOOD.func_176223_P().func_177226_a((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(finalRotation)), 3);
            } else {
                world.func_180501_a(pos, ModBlocks.SIGN_WALL_METAL.func_176223_P().func_177226_a((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(finalRotation)), 3);
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190920_e(stack.func_190916_E() - 1);
        }
        if ((tileEntity = world.func_175625_s(pos)) instanceof TileEntityMoarSign && !ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack)) {
            TileEntityMoarSign te = (TileEntityMoarSign)tileEntity;
            String texture = ItemMoarSign.getTextureFromNBTFull(stack.func_77978_p());
            te.isMetal = info.isMetal;
            te.func_145912_a(player);
            te.setResourceLocation(texture);
            boolean moving = stack.func_77978_p().func_74764_b("SignMoving") && stack.func_77978_p().func_74767_n("SignMoving");
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSignOpenGui(te, moving), (EntityPlayerMP)player);
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag extraInfo) {
        SignInfo info = ItemMoarSign.getInfo(stack.func_77978_p());
        if (info != null) {
            String modName = info.activateTag.equals("activeALL") ? "Minecraft" : info.activateTag;
            tooltip.add(Localization.ITEM.SIGN.MATERIAL_ORIGIN.translate((Object)((Object)Colors.WHITE) + Utils.getModName(modName)));
            if (extraInfo.func_194127_a()) {
                tooltip.add(Localization.ITEM.SIGN.MATERIAL.translate((Object)((Object)Colors.WHITE) + info.material.materialName));
            }
        } else {
            tooltip.add((Object)((Object)Colors.RED) + Localization.ITEM.SIGN.ERROR.translate(Colors.RED.toString()));
        }
    }
}

