/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.jei.exchange;

import gory_moon.moarsigns.integration.jei.MoarSignsPlugin;
import gory_moon.moarsigns.integration.jei.exchange.ExchangeRecipe;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class MoarSignsExchangeCategory
implements IRecipeCategory<ExchangeRecipe> {
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;

    public MoarSignsExchangeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("moarsigns", "textures/gui/sign_exchange_nei.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 164, 118);
        this.localizedName = I18n.translateToLocal((String)"crafting.moarsigns.sign.exchange");
    }

    @Nonnull
    public String getUid() {
        return "moarsigns.exchange";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "MoarSigns";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, ExchangeRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 74, 12);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = 1 + x + y * 9;
                guiItemStacks.init(index, false, 2 + x * 18, 42 + y * 18);
            }
        }
        guiItemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        for (int i = 0; i < ingredients.getOutputs(VanillaTypes.ITEM).size(); ++i) {
            Object recipeItem = ingredients.getOutputs(VanillaTypes.ITEM).get(i);
            List itemStacks = MoarSignsPlugin.jeiHelpers.getStackHelper().toItemStackList(recipeItem);
            guiItemStacks.set(1 + i, itemStacks);
        }
    }
}

