/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import gory_moon.moarsigns.MoarSignsCreativeTab;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.BlockMoarSign;
import gory_moon.moarsigns.blocks.ModBlocks;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignOpenGui;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemMoarSign
extends Item {
    public ItemMoarSign() {
        this.maxStackSize = 16;
        this.setCreativeTab(MoarSignsCreativeTab.tabMS);
        this.setRegistryName("moar_sign");
        this.setTranslationKey("moarsigns");
        this.hasSubtypes = true;
    }

    public static String getTextureFromNBTFull(NBTTagCompound compound) {
        return compound != null && compound.hasKey("SignTexture") ? compound.getString("SignTexture") : "";
    }

    public static String getTextureFromNBT(NBTTagCompound compound) {
        String texture = ItemMoarSign.getTextureFromNBTFull(compound);
        if (texture.contains("\\")) {
            texture = texture.split("\\\\")[1];
        }
        if (texture.contains("/")) {
            texture = texture.split("/")[1];
        }
        return texture;
    }

    public static SignInfo getInfo(NBTTagCompound compound) {
        String texture = ItemMoarSign.getTextureFromNBTFull(compound);
        return SignRegistry.get(texture);
    }

    public String getTranslationKey(ItemStack stack) {
        SignInfo info = SignRegistry.get(ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound()));
        if (info == null) {
            return super.getTranslationKey() + ".sign.error";
        }
        return super.getTranslationKey() + ".sign." + (info.material.path.equals("") ? "" : info.material.path.replace("/", "") + ".") + ItemMoarSign.getTextureFromNBT(stack.getTagCompound());
    }

    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.isInCreativeTab(tab)) {
            this.getSubItemStacks((List)items);
        }
    }

    public void getSubItemStacks(List list) {
        ArrayList<SignInfo> signRegistry = SignRegistry.getActivatedSignRegistry();
        for (SignInfo info : signRegistry) {
            list.add(this.createMoarItemStack(info.material.path + info.itemName, info.isMetal));
        }
    }

    public EnumRarity getRarity(ItemStack stack) {
        SignInfo info = SignRegistry.get(ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound()));
        if (info != null) {
            return info.rarity;
        }
        return EnumRarity.COMMON;
    }

    public ItemStack createMoarItemStack(String signName, boolean isMetal) {
        ItemStack itemStack = new ItemStack((Item)this, 1, isMetal ? 1 : 0);
        NBTTagCompound compound = new NBTTagCompound();
        compound.setString("SignTexture", signName.replace("\\", "/"));
        itemStack.setTagCompound(compound);
        return itemStack;
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        SignInfo info;
        ItemStack stack = player.getHeldItem(hand);
        if (!world.getBlockState(pos).getMaterial().isSolid()) {
            return EnumActionResult.PASS;
        }
        if (!player.canPlayerEdit(pos = pos.offset(facing), facing, stack) || !ModBlocks.SIGN_STANDING_WOOD.canPlaceBlockAt(world, pos)) {
            return EnumActionResult.PASS;
        }
        if (world.isRemote) {
            return EnumActionResult.PASS;
        }
        if (stack.getItem() instanceof ItemSignToolbox) {
            NBTTagCompound toolbox = stack.getTagCompound();
            String texture = toolbox.getString("texture");
            boolean isMetal = toolbox.getBoolean("isMetal");
            stack = ModItems.SIGN.createMoarItemStack(texture, isMetal);
            stack.getTagCompound().setBoolean("SignMoving", true);
        }
        if ((info = ItemMoarSign.getInfo(stack.getTagCompound())) == null) {
            return EnumActionResult.PASS;
        }
        if (facing == EnumFacing.UP && !player.isSneaking()) {
            int rotation = MathHelper.floor((double)((double)((player.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
            if (!info.isMetal) {
                world.setBlockState(pos, ModBlocks.SIGN_STANDING_WOOD.getDefaultState().withProperty((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(rotation)), 3);
            } else {
                world.setBlockState(pos, ModBlocks.SIGN_STANDING_METAL.getDefaultState().withProperty((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(rotation)), 3);
            }
        } else {
            int finalRotation = facing.getIndex();
            if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                int rotation = MathHelper.floor((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                finalRotation += rotation << 1;
                finalRotation += 8;
            }
            if (!info.isMetal) {
                world.setBlockState(pos, ModBlocks.SIGN_WALL_WOOD.getDefaultState().withProperty((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(finalRotation)), 3);
            } else {
                world.setBlockState(pos, ModBlocks.SIGN_WALL_METAL.getDefaultState().withProperty((IProperty)BlockMoarSign.ROTATION, (Comparable)Integer.valueOf(finalRotation)), 3);
            }
        }
        if (!player.capabilities.isCreativeMode) {
            stack.setCount(stack.getCount() - 1);
        }
        if ((tileEntity = world.getTileEntity(pos)) instanceof TileEntityMoarSign && !ItemBlock.setTileEntityNBT((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack)) {
            TileEntityMoarSign te = (TileEntityMoarSign)tileEntity;
            String texture = ItemMoarSign.getTextureFromNBTFull(stack.getTagCompound());
            te.isMetal = info.isMetal;
            te.setPlayer(player);
            te.setResourceLocation(texture);
            boolean moving = stack.getTagCompound().hasKey("SignMoving") && stack.getTagCompound().getBoolean("SignMoving");
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSignOpenGui(te, moving), (EntityPlayerMP)player);
        }
        return EnumActionResult.SUCCESS;
    }

    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag extraInfo) {
        SignInfo info = ItemMoarSign.getInfo(stack.getTagCompound());
        if (info != null) {
            String modName = info.activateTag.equals("activeALL") ? "Minecraft" : info.activateTag;
            tooltip.add(Localization.ITEM.SIGN.MATERIAL_ORIGIN.translate((Object)((Object)Colors.WHITE) + Utils.getModName(modName)));
            if (extraInfo.isAdvanced()) {
                tooltip.add(Localization.ITEM.SIGN.MATERIAL.translate((Object)((Object)Colors.WHITE) + info.material.materialName));
            }
        } else {
            tooltip.add((Object)((Object)Colors.RED) + Localization.ITEM.SIGN.ERROR.translate(Colors.RED.toString()));
        }
    }
}

