/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.interfaces.containers;

import gory_moon.moarsigns.client.interfaces.containers.InventoryExchange;
import gory_moon.moarsigns.client.interfaces.containers.slots.SlotInput;
import gory_moon.moarsigns.client.interfaces.containers.slots.SlotSelection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ContainerExchange
extends Container {
    public final InventoryExchange inventory;
    private InventoryPlayer playerInventory;
    private ItemStack itemToolBox;
    public boolean close;
    public int toolBoxSlot;

    public ContainerExchange(InventoryPlayer inventoryPlayer, InventoryExchange exchangeInv, EnumHand hand) {
        int x;
        int y;
        this.inventory = exchangeInv;
        this.playerInventory = inventoryPlayer;
        this.toolBoxSlot = hand == EnumHand.MAIN_HAND ? this.playerInventory.currentItem : this.playerInventory.getSizeInventory() - 1;
        exchangeInv.container = this;
        this.addSlotToContainer(new SlotInput(this, exchangeInv, 0, 22, 26));
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlotToContainer(new SlotSelection(this, exchangeInv, x + y * 9 + 1, 58 + 18 * x, 8 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, x2, 40 + 18 * x2, 138));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, x + y * 9 + 9, 40 + 18 * x, 80 + y * 18));
            }
        }
        this.itemToolBox = inventoryPlayer.getCurrentItem();
        this.inventory.update();
    }

    public void onSlotChanged() {
        ItemStack stack = (ItemStack)this.playerInventory.mainInventory.get(this.toolBoxSlot);
        if (stack.isEmpty() || !stack.isItemEqual(this.itemToolBox)) {
            this.close = true;
        }
    }

    public ItemStack slotClick(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        int clickedSlot;
        if (clickTypeIn != ClickType.QUICK_CRAFT && slotId >= 0 && ((clickedSlot = slotId - this.inventory.getSizeInventory()) == this.toolBoxSlot || clickTypeIn == ClickType.SWAP && dragType == this.toolBoxSlot)) {
            return ItemStack.EMPTY;
        }
        return super.slotClick(slotId, dragType, clickTypeIn, player);
    }

    public void onContainerClosed(EntityPlayer player) {
        this.inventory.clearInventory();
        if (!player.inventory.addItemStackToInventory(this.inventory.getStackInSlot(0))) {
            InventoryHelper.dropInventoryItems((World)player.world, (Entity)player, (IInventory)this.inventory);
        }
        super.onContainerClosed(player);
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.inventory.isUsableByPlayer(player);
    }

    public ItemStack transferStackInSlot(EntityPlayer entity, int slotIdx) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(slotIdx);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemStack1 = slot.getStack();
            itemStack = itemStack1.copy();
            if (slotIdx > 27) {
                if (((Slot)this.inventorySlots.get(0)).isItemValid(itemStack1) && !this.mergeItemStack(itemStack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (slotIdx < 28 && !itemStack1.isEmpty()) {
                    ItemStack tempStack = entity.inventory.getItemStack();
                    entity.inventory.setItemStack(itemStack1.copy());
                    slot.onTake(entity, itemStack1);
                    itemStack1 = entity.inventory.getItemStack();
                    entity.inventory.setItemStack(tempStack);
                }
                if (!this.mergeItemStack(itemStack1, 28, 64, false)) {
                    return ItemStack.EMPTY;
                }
            }
            slot.onSlotChange(itemStack1, itemStack);
            if (itemStack1.getCount() == 0) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
            if (itemStack1.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            if (slotIdx > 28 || slotIdx == 0) {
                slot.onTake(entity, itemStack1);
            }
            if (itemStack1.getCount() == 0) {
                slot.putStack(ItemStack.EMPTY);
                return ItemStack.EMPTY;
            }
            slot.putStack(itemStack1);
            return itemStack1;
        }
        return itemStack;
    }
}

