/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.MaterialRegistry;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignSpecialProperty;
import gory_moon.moarsigns.integration.IntegrationHandler;
import gory_moon.moarsigns.util.IntegrationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class SignRegistry {
    public static final String ALWAYS_ACTIVE_TAG = "activeALL";
    private static ArrayList<SignInfo> signRegistry;
    private static ArrayList<SignInfo> activatedSignRegistry;
    private static HashMap<String, Boolean> activeTags;
    private static HashMap<SignInfo, ArrayList<MaterialInfo>> alternativeRecipeMaterial;

    public static SignInfo register(String itemName, SignSpecialProperty property, String materialName, String path, boolean gotNugget, ItemStack materialItemStack, ItemStack materialBlock, String modId) throws IntegrationException {
        if ((materialItemStack == null || materialItemStack.func_77973_b() == null) && IntegrationHandler.donePreSetup()) {
            throw new IntegrationException("Material " + materialName + " is null for sign " + itemName);
        }
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack, materialBlock);
        return SignRegistry.register(itemName, property, info, modId, ALWAYS_ACTIVE_TAG);
    }

    public static SignInfo register(String itemName, SignSpecialProperty property, String materialName, String path, boolean gotNugget, ItemStack materialItemStack, ItemStack materialBlock, String modId, String activateTag) throws IntegrationException {
        if ((materialItemStack == null || materialItemStack.func_77973_b() == null) && IntegrationHandler.donePreSetup()) {
            throw new IntegrationException("Material " + materialName + " is null for sign " + itemName);
        }
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack, materialBlock);
        return SignRegistry.register(itemName, property, info, modId, activateTag);
    }

    public static SignInfo register(String itemName, SignSpecialProperty property, String materialName, String path, boolean gotNugget, ItemStack materialItemStack, String modId) throws IntegrationException {
        if ((materialItemStack == null || materialItemStack.func_77973_b() == null) && IntegrationHandler.donePreSetup()) {
            throw new IntegrationException("Material " + materialName + " is null for sign " + itemName);
        }
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack);
        return SignRegistry.register(itemName, property, info, modId, ALWAYS_ACTIVE_TAG);
    }

    public static SignInfo register(String itemName, SignSpecialProperty property, String materialName, String path, boolean gotNugget, ItemStack materialItemStack, String modId, String activateTag) throws IntegrationException {
        if ((materialItemStack == null || materialItemStack.func_77973_b() == null) && IntegrationHandler.donePreSetup()) {
            throw new IntegrationException("Material " + materialName + " is null for sign " + itemName);
        }
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack);
        return SignRegistry.register(itemName, property, info, modId, activateTag);
    }

    private static SignInfo register(String itemName, SignSpecialProperty property, MaterialInfo material, String modId, String activateTag) {
        if (!MaterialRegistry.contains(material)) {
            MaterialRegistry.register(material);
        }
        SignInfo signInfo = new SignInfo(itemName, material, property, modId, activateTag);
        signRegistry.add(signInfo);
        if (!activeTags.containsKey(activateTag)) {
            activeTags.put(activateTag, false);
        } else if (activeTags.get(activateTag).booleanValue()) {
            activatedSignRegistry.add(signInfo);
        }
        return signInfo;
    }

    public static MaterialInfo registerAlternativeMaterial(SignInfo sInfo, String materialName, String path, boolean gotNugget, ItemStack materialItemStack) throws IntegrationException {
        if ((materialItemStack == null || materialItemStack.func_77973_b() == null) && IntegrationHandler.donePreSetup()) {
            throw new IntegrationException("Material " + materialName + " is null for sign " + sInfo.itemName);
        }
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack);
        return SignRegistry.registerAlternativeMaterial(sInfo, info);
    }

    public static MaterialInfo registerAlternativeMaterial(SignInfo sInfo, String materialName, String path, boolean gotNugget, ItemStack materialItemStack, ItemStack materialBlock) throws IntegrationException {
        if ((materialItemStack == null || materialItemStack.func_77973_b() == null) && IntegrationHandler.donePreSetup()) {
            throw new IntegrationException("Material " + materialName + " is null for sign " + sInfo.itemName);
        }
        MaterialInfo info = MaterialRegistry.register(materialName, path, gotNugget, materialItemStack, materialBlock);
        return SignRegistry.registerAlternativeMaterial(sInfo, info);
    }

    public static MaterialInfo registerAlternativeMaterial(SignInfo sInfo, MaterialInfo mInfo) throws IntegrationException {
        if ((sInfo == null || mInfo == null) && IntegrationHandler.donePreSetup()) {
            throw new IntegrationException("Material " + mInfo.materialName + " is null for sign " + sInfo.itemName);
        }
        if (alternativeRecipeMaterial.containsKey(sInfo)) {
            alternativeRecipeMaterial.get(sInfo).add(mInfo);
        } else {
            ArrayList<MaterialInfo> i = new ArrayList<MaterialInfo>();
            i.add(mInfo);
            alternativeRecipeMaterial.put(sInfo, i);
        }
        return mInfo;
    }

    public static void activateTag(String tag) {
        activeTags.put(tag, true);
        for (SignInfo info : signRegistry) {
            if (!info.activateTag.equals(tag)) continue;
            activatedSignRegistry.add(info);
        }
    }

    public static void deactivateTag(String tag) {
        activeTags.put(tag, false);
        for (SignInfo info : activatedSignRegistry) {
            if (!info.activateTag.equals(tag)) continue;
            activatedSignRegistry.remove(info);
        }
    }

    public static SignInfo get(String s) {
        for (SignInfo info : signRegistry) {
            if (!(info.material.path.replace("\\", "/") + info.itemName).equals(s)) continue;
            return info;
        }
        return null;
    }

    public static List<MaterialInfo> getAlternativeMaterials(SignInfo info) {
        if (alternativeRecipeMaterial.containsKey(info)) {
            return alternativeRecipeMaterial.get(info);
        }
        return Lists.newArrayList();
    }

    public static ArrayList<SignInfo> getSignInfoFromMaterials(HashSet<MaterialInfo> materials) {
        HashSet signInfos = Sets.newHashSet();
        block0: for (SignInfo info : activatedSignRegistry) {
            for (MaterialInfo materialInfo : materials) {
                if (info.material.materialName.equals(materialInfo.materialName)) {
                    signInfos.add(info);
                    continue block0;
                }
                for (Map.Entry<SignInfo, ArrayList<MaterialInfo>> entry : alternativeRecipeMaterial.entrySet()) {
                    for (MaterialInfo info1 : entry.getValue()) {
                        if (!info1.equals(materialInfo)) continue;
                        signInfos.add(entry.getKey());
                    }
                }
            }
        }
        return new ArrayList<SignInfo>(signInfos);
    }

    public static ArrayList<SignInfo> getSignRegistry() {
        return (ArrayList)signRegistry.clone();
    }

    public static ArrayList<SignInfo> getActivatedSignRegistry() {
        return (ArrayList)activatedSignRegistry.clone();
    }

    public static ArrayList<String> getTextureLocations(boolean includeModID) {
        ArrayList<String> list = SignRegistry.getTextureLocations(false, includeModID);
        list.addAll(SignRegistry.getTextureLocations(true, includeModID));
        return list;
    }

    public static ArrayList<String> getTextureLocations(boolean isMetal, boolean includeModID) {
        ArrayList list = Lists.newArrayList();
        for (SignInfo info : signRegistry) {
            if (info.isMetal != isMetal) continue;
            list.add((includeModID ? info.modId + ":" : "") + "signs/" + info.material.path + info.itemName);
        }
        return list;
    }

    public static HashMap<String, Boolean> getActiveTags() {
        return (HashMap)activeTags.clone();
    }

    public static int getActiveTagsAmount() {
        int i = 0;
        for (boolean b : activeTags.values()) {
            if (!b) continue;
            ++i;
        }
        return i;
    }

    public static void clear() {
        signRegistry.clear();
        activatedSignRegistry.clear();
        activeTags.clear();
        alternativeRecipeMaterial.clear();
        SignRegistry.activateTag(ALWAYS_ACTIVE_TAG);
    }

    public static void sortRegistry() {
        activatedSignRegistry.sort((o1, o2) -> o1.isMetal && !o2.isMetal ? 1 : (!o1.isMetal && o2.isMetal ? -1 : ("".equals(o1.material.path) && o1.material.path.equals(o2.material.path) ? 0 : (o1.material.path.equals(o2.material.path) ? o1.itemName.compareToIgnoreCase(o2.itemName) : o1.material.path.compareTo(o2.material.path)))));
    }

    static {
        activeTags = Maps.newHashMap();
        signRegistry = Lists.newArrayList();
        activatedSignRegistry = Lists.newArrayList();
        alternativeRecipeMaterial = Maps.newHashMap();
        SignRegistry.activateTag(ALWAYS_ACTIVE_TAG);
    }
}

