/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.blocks;

import cofh.api.item.IToolHammer;
import crazypants.enderio.api.tool.ITool;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.client.particle.EntityDiggingFXMoarSigns;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoAccessor", modid="theoneprobe")
public class BlockMoarSign
extends BlockContainer
implements IProbeInfoAccessor {
    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)15);
    protected static final AxisAlignedBB SIGN_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);

    public BlockMoarSign(Material material, SoundType stepSound, float hardness, float resistance, String registryname, String harvestLevel, int level) {
        super(material);
        this.setRegistryName(registryname);
        this.func_149663_c("moarsign.sign");
        this.func_149672_a(stepSound);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.setHarvestLevel(harvestLevel, level);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SIGN_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_181623_g() {
        return true;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityMoarSign();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(rot.func_185833_a(((Integer)state.func_177229_b((IProperty)ROTATION)).intValue(), 16)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(mirrorIn.func_185802_a(((Integer)state.func_177229_b((IProperty)ROTATION)).intValue(), 16)));
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        SignInfo signInfo = this.getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.randomDisplayTick(state, world, pos, rand);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        SignInfo signInfo = this.getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.onEntityCollidedWithBlock(world, pos, state, entity);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null && heldItem.func_77973_b() instanceof IToolHammer && !(heldItem.func_77973_b() instanceof ItemSignToolbox) && ((IToolHammer)heldItem.func_77973_b()).isUsable(heldItem, (EntityLivingBase)player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            ItemSignToolbox.doRotate(world, pos, player);
            ((IToolHammer)heldItem.func_77973_b()).toolUsed(heldItem, (EntityLivingBase)player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (heldItem != null && heldItem.func_77973_b() instanceof ITool && ((ITool)heldItem.func_77973_b()).canUse(heldItem, player, pos)) {
            ItemSignToolbox.doRotate(world, pos, player);
            ((ITool)heldItem.func_77973_b()).used(heldItem, player, pos);
            return true;
        }
        SignInfo signInfo = this.getSignInfo(world, pos);
        boolean returnVal = true;
        if (signInfo != null && signInfo.property != null) {
            returnVal = signInfo.property.onRightClick(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
        }
        if (world.field_72995_K) {
            return returnVal;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        return returnVal && tileentity instanceof TileEntityMoarSign && ((TileEntityMoarSign)tileentity).func_174882_b(player);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        IBlockState state = world.func_180495_p(pos);
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                    effectRenderer.func_78873_a((Particle)new EntityDiggingFXMoarSigns(world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, pos, state).func_174846_a(pos));
                }
            }
        }
        return true;
    }

    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        BlockPos pos = target.func_178782_a();
        EnumFacing side = target.field_178784_b;
        IBlockState iblockstate = world.func_180495_p(pos);
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        float f = 0.1f;
        AxisAlignedBB axisalignedbb = iblockstate.func_185900_c((IBlockAccess)world, pos);
        double d0 = (double)i + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72340_a;
        double d1 = (double)j + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72338_b;
        double d2 = (double)k + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72339_c;
        if (side == EnumFacing.DOWN) {
            d1 = (double)j + axisalignedbb.field_72338_b - (double)f;
        }
        if (side == EnumFacing.UP) {
            d1 = (double)j + axisalignedbb.field_72337_e + (double)f;
        }
        if (side == EnumFacing.NORTH) {
            d2 = (double)k + axisalignedbb.field_72339_c - (double)f;
        }
        if (side == EnumFacing.SOUTH) {
            d2 = (double)k + axisalignedbb.field_72334_f + (double)f;
        }
        if (side == EnumFacing.WEST) {
            d0 = (double)i + axisalignedbb.field_72340_a - (double)f;
        }
        if (side == EnumFacing.EAST) {
            d0 = (double)i + axisalignedbb.field_72336_d + (double)f;
        }
        effectRenderer.func_78873_a(new EntityDiggingFXMoarSigns(world, d0, d1, d2, 0.0, 0.0, 0.0, pos, iblockstate).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityMoarSign tileEntity = (TileEntityMoarSign)world.func_175625_s(pos);
        String s = tileEntity.texture_name;
        s = s != null ? s : "null";
        return ModItems.SIGN.createMoarItemStack(s, tileEntity.isMetal);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.func_176226_b(world, pos, state, 0);
        super.func_180663_b(world, pos, state);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileEntity = (TileEntityMoarSign)entity;
            if (tileEntity.removeNoDrop || tileEntity.texture_name == null) {
                return ret;
            }
            ret.add(ModItems.SIGN.createMoarItemStack(tileEntity.texture_name, tileEntity.isMetal));
        }
        return ret;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityMoarSign) {
            ((TileEntityMoarSign)entity).removeNoDrop = player.field_71075_bZ.field_75098_d;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return !this.func_181087_e(world, pos) && super.func_176196_c(world, pos);
    }

    public SignInfo getSignInfo(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMoarSign) {
            TileEntityMoarSign sign = (TileEntityMoarSign)tileEntity;
            return SignRegistry.get(sign.texture_name);
        }
        return null;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        SignInfo info = this.getSignInfo(world, data.getPos());
        String modName = info.activateTag.equals("activeALL") ? "Minecraft" : info.activateTag;
        probeInfo.text((Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGN.MATERIAL_ORIGIN.translate((Object)((Object)Colors.WHITE) + Utils.getModName(modName)));
        if (mode.equals((Object)ProbeMode.EXTENDED) || mode.equals((Object)ProbeMode.DEBUG)) {
            probeInfo.text((Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGN.MATERIAL.translate((Object)((Object)Colors.WHITE) + info.material.materialName));
        }
    }
}

