/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.blocks;

import cofh.api.item.IToolHammer;
import crazypants.enderio.api.tool.ITool;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.client.particle.EntityDiggingFXMoarSigns;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoAccessor", modid="theoneprobe")
public class BlockMoarSign
extends BlockContainer
implements IProbeInfoAccessor {
    public static final PropertyInteger ROTATION = PropertyInteger.create((String)"rotation", (int)0, (int)15);
    protected static final AxisAlignedBB SIGN_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);

    public BlockMoarSign(Material material, SoundType stepSound) {
        super(material);
        this.setUnlocalizedName("moarsign.sign");
        this.setSoundType(stepSound);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SIGN_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, World worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isPassable(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean canSpawnInBlock() {
        return true;
    }

    public TileEntity createNewTileEntity(World var1, int var2) {
        return new TileEntityMoarSign();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)ROTATION, (Comparable)Integer.valueOf(rot.rotate(((Integer)state.getValue((IProperty)ROTATION)).intValue(), 16)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withProperty((IProperty)ROTATION, (Comparable)Integer.valueOf(mirrorIn.mirrorRotation(((Integer)state.getValue((IProperty)ROTATION)).intValue(), 16)));
    }

    public void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random rand) {
        SignInfo signInfo = this.getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.randomDisplayTick(state, world, pos, rand);
        }
    }

    public void onEntityCollidedWithBlock(World world, BlockPos pos, IBlockState state, Entity entity) {
        SignInfo signInfo = this.getSignInfo(world, pos);
        if (signInfo != null && signInfo.property != null) {
            signInfo.property.onEntityCollidedWithBlock(world, pos, state, entity);
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null && heldItem.getItem() instanceof IToolHammer && !(heldItem.getItem() instanceof ItemSignToolbox) && ((IToolHammer)heldItem.getItem()).isUsable(heldItem, (EntityLivingBase)player, pos.getX(), pos.getY(), pos.getZ())) {
            ItemSignToolbox.doRotate(world, pos, player);
            ((IToolHammer)heldItem.getItem()).toolUsed(heldItem, (EntityLivingBase)player, pos.getX(), pos.getY(), pos.getZ());
            return true;
        }
        if (heldItem != null && heldItem.getItem() instanceof ITool && ((ITool)heldItem.getItem()).canUse(heldItem, player, pos)) {
            ItemSignToolbox.doRotate(world, pos, player);
            ((ITool)heldItem.getItem()).used(heldItem, player, pos);
            return true;
        }
        SignInfo signInfo = this.getSignInfo(world, pos);
        boolean returnVal = true;
        if (signInfo != null && signInfo.property != null) {
            returnVal = signInfo.property.onRightClick(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
        }
        if (world.isRemote) {
            return returnVal;
        }
        TileEntity tileentity = world.getTileEntity(pos);
        return returnVal && tileentity instanceof TileEntityMoarSign && ((TileEntityMoarSign)tileentity).executeCommand(player);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        IBlockState state = world.getBlockState(pos);
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.getX() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.getY() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.getZ() + ((double)l + 0.5) / (double)i;
                    effectRenderer.addEffect((Particle)new EntityDiggingFXMoarSigns(world, d0, d1, d2, d0 - (double)pos.getX() - 0.5, d1 - (double)pos.getY() - 0.5, d2 - (double)pos.getZ() - 0.5, pos, state).setBlockPos(pos));
                }
            }
        }
        return true;
    }

    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        BlockPos pos = target.getBlockPos();
        EnumFacing side = target.sideHit;
        IBlockState iblockstate = world.getBlockState(pos);
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        float f = 0.1f;
        AxisAlignedBB axisalignedbb = iblockstate.getBoundingBox((IBlockAccess)world, pos);
        double d0 = (double)i + world.rand.nextDouble() * (axisalignedbb.maxX - axisalignedbb.minX - (double)(f * 2.0f)) + (double)f + axisalignedbb.minX;
        double d1 = (double)j + world.rand.nextDouble() * (axisalignedbb.maxY - axisalignedbb.minY - (double)(f * 2.0f)) + (double)f + axisalignedbb.minY;
        double d2 = (double)k + world.rand.nextDouble() * (axisalignedbb.maxZ - axisalignedbb.minZ - (double)(f * 2.0f)) + (double)f + axisalignedbb.minZ;
        if (side == EnumFacing.DOWN) {
            d1 = (double)j + axisalignedbb.minY - (double)f;
        }
        if (side == EnumFacing.UP) {
            d1 = (double)j + axisalignedbb.maxY + (double)f;
        }
        if (side == EnumFacing.NORTH) {
            d2 = (double)k + axisalignedbb.minZ - (double)f;
        }
        if (side == EnumFacing.SOUTH) {
            d2 = (double)k + axisalignedbb.maxZ + (double)f;
        }
        if (side == EnumFacing.WEST) {
            d0 = (double)i + axisalignedbb.minX - (double)f;
        }
        if (side == EnumFacing.EAST) {
            d0 = (double)i + axisalignedbb.maxX + (double)f;
        }
        effectRenderer.addEffect(new EntityDiggingFXMoarSigns(world, d0, d1, d2, 0.0, 0.0, 0.0, pos, iblockstate).setBlockPos(pos).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f));
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityMoarSign tileEntity = (TileEntityMoarSign)world.getTileEntity(pos);
        String s = tileEntity.texture_name;
        s = s != null ? s : "null";
        return ModItems.SIGN.createMoarItemStack(s, tileEntity.isMetal);
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.dropBlockAsItem(world, pos, state, 0);
        super.breakBlock(world, pos, state);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity entity = world.getTileEntity(pos);
        if (entity instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileEntity = (TileEntityMoarSign)entity;
            if (tileEntity.removeNoDrop || tileEntity.texture_name == null) {
                return ret;
            }
            ret.add(ModItems.SIGN.createMoarItemStack(tileEntity.texture_name, tileEntity.isMetal));
        }
        return ret;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity entity = world.getTileEntity(pos);
        if (entity instanceof TileEntityMoarSign) {
            ((TileEntityMoarSign)entity).removeNoDrop = player.capabilities.isCreativeMode;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        return !this.hasInvalidNeighbor(world, pos) && super.canPlaceBlockAt(world, pos);
    }

    public SignInfo getSignInfo(World world, BlockPos pos) {
        TileEntity tileEntity = world.getTileEntity(pos);
        if (tileEntity instanceof TileEntityMoarSign) {
            TileEntityMoarSign sign = (TileEntityMoarSign)tileEntity;
            return SignRegistry.get(sign.texture_name);
        }
        return null;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        SignInfo info = this.getSignInfo(world, data.getPos());
        String modName = info.activateTag.equals("activeALL") ? "Minecraft" : info.activateTag;
        probeInfo.text((Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGN.MATERIAL_ORIGIN.translate((Object)((Object)Colors.WHITE) + Utils.getModName(modName)));
        if (mode.equals((Object)ProbeMode.EXTENDED) || mode.equals((Object)ProbeMode.DEBUG)) {
            probeInfo.text((Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGN.MATERIAL.translate((Object)((Object)Colors.WHITE) + info.material.materialName));
        }
    }
}

