/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.tileentites;

import com.google.gson.JsonParseException;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.World;

public class TileEntityMoarSign
extends TileEntitySign
implements ITickable {
    public static final String NBT_VERSION_TAG = "nbtVersion";
    public static final String NBT_SETTINGS_TAG = "settings";
    public static final String NBT_LOCKED_CHANGES_TAG = "lockedChanges";
    public static final String NBT_METAL_TAG = "isMetal";
    public static final String NBT_TEXTURE_TAG = "texture";
    private final int NBT_VERSION = 2;
    public int[] rowLocations = new int[4];
    public int[] rowSizes = new int[]{0, 0, 0, 0};
    public boolean[] visibleRows = new boolean[]{true, true, true, true};
    public boolean[] shadowRows = new boolean[4];
    public boolean lockedChanges;
    public boolean isMetal = false;
    public String texture_name;
    public boolean showInGui = false;
    public boolean removeNoDrop;
    private boolean isEditable = true;
    private EntityPlayer playerEditing;
    private ResourceLocation resourceLocation;
    private boolean textureReq = false;

    public TileEntityMoarSign() {
        for (int i = 0; i < 4; ++i) {
            this.rowLocations[i] = 2 + 10 * i;
        }
    }

    public void setBlockType(Block block) {
        this.blockType = block;
    }

    public void update() {
        if (this.worldObj.isRemote) {
            SignInfo sign;
            if (!this.textureReq) {
                this.textureReq = true;
                Block block = this.worldObj.getBlockState(this.pos).getBlock();
                this.worldObj.addBlockEvent(this.pos, block, 0, 0);
            }
            if ((sign = SignRegistry.get(this.texture_name)) != null && sign.property != null) {
                sign.property.onUpdate();
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setInteger(NBT_VERSION_TAG, 2);
        NBTTagList settings = new NBTTagList();
        int[] loc = new int[5];
        loc[0] = 0;
        System.arraycopy(this.rowLocations, 0, loc, 1, 4);
        int[] size = new int[5];
        size[0] = 1;
        System.arraycopy(this.rowSizes, 0, size, 1, 4);
        int[] visible = new int[5];
        visible[0] = 2;
        for (int i = 0; i < 4; ++i) {
            visible[i + 1] = this.visibleRows[i] ? 1 : 0;
        }
        int[] shadow = new int[5];
        shadow[0] = 3;
        for (int i = 0; i < 4; ++i) {
            shadow[i + 1] = this.shadowRows[i] ? 1 : 0;
        }
        NBTTagIntArray locations = new NBTTagIntArray(loc);
        NBTTagIntArray sizes = new NBTTagIntArray(size);
        NBTTagIntArray hidden = new NBTTagIntArray(visible);
        NBTTagIntArray shadows = new NBTTagIntArray(shadow);
        settings.appendTag((NBTBase)locations);
        settings.appendTag((NBTBase)sizes);
        settings.appendTag((NBTBase)hidden);
        settings.appendTag((NBTBase)shadows);
        compound.setTag(NBT_SETTINGS_TAG, (NBTBase)settings);
        compound.setBoolean(NBT_LOCKED_CHANGES_TAG, this.lockedChanges);
        compound.setBoolean(NBT_METAL_TAG, this.isMetal);
        if (this.texture_name != null) {
            compound.setString(NBT_TEXTURE_TAG, this.texture_name);
        }
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        ICommandSender icommandsender = new ICommandSender(){

            public String getName() {
                return "Sign";
            }

            public ITextComponent getDisplayName() {
                return new TextComponentString(this.getName());
            }

            public void addChatMessage(ITextComponent component) {
            }

            public boolean canCommandSenderUseCommand(int permLevel, String commandName) {
                return permLevel <= 2;
            }

            public BlockPos getPosition() {
                return TileEntityMoarSign.this.pos;
            }

            public Vec3d getPositionVector() {
                return new Vec3d((double)TileEntityMoarSign.this.pos.getX() + 0.5, (double)TileEntityMoarSign.this.pos.getY() + 0.5, (double)TileEntityMoarSign.this.pos.getZ() + 0.5);
            }

            public World getEntityWorld() {
                return TileEntityMoarSign.this.worldObj;
            }

            public Entity getCommandSenderEntity() {
                return null;
            }

            public boolean sendCommandFeedback() {
                return false;
            }

            public void setCommandStat(CommandResultStats.Type type, int amount) {
            }

            public MinecraftServer getServer() {
                return TileEntityMoarSign.this.worldObj.getMinecraftServer();
            }
        };
        int nbtVersion = compound.getInteger(NBT_VERSION_TAG);
        if (nbtVersion == 1) {
            int fontSize = compound.getInteger("fontSize");
            int rows = Utils.getRows(fontSize);
            this.rowSizes = new int[]{fontSize, fontSize, fontSize, fontSize};
            this.visibleRows = new boolean[]{false, false, false, false};
            for (int i = 0; i < rows; ++i) {
                this.visibleRows[i] = true;
            }
            int textOffset = compound.getInteger("textOffset");
            for (int i = 0; i < 4; ++i) {
                int temp = Math.abs(textOffset) + this.rowLocations[i] - (textOffset != 0 ? 2 : 0);
                if (temp < 0) {
                    temp = 0;
                }
                this.rowLocations[i] = temp;
            }
        } else if (nbtVersion == 2) {
            this.lockedChanges = compound.getBoolean(NBT_LOCKED_CHANGES_TAG);
            NBTTagList settings = compound.getTagList(NBT_SETTINGS_TAG, 11);
            for (int i = 0; i < settings.tagCount(); ++i) {
                int j;
                int[] array = settings.getIntArrayAt(i);
                if (array[0] == 0) {
                    System.arraycopy(array, 1, this.rowLocations, 0, 4);
                    continue;
                }
                if (array[0] == 1) {
                    System.arraycopy(array, 1, this.rowSizes, 0, 4);
                    continue;
                }
                if (array[0] == 2) {
                    int[] hidden = new int[4];
                    System.arraycopy(array, 1, hidden, 0, 4);
                    for (j = 0; j < 4; ++j) {
                        this.visibleRows[j] = hidden[j] == 1;
                    }
                    continue;
                }
                if (array[0] != 3) continue;
                int[] shadows = new int[4];
                System.arraycopy(array, 1, shadows, 0, 4);
                for (j = 0; j < 4; ++j) {
                    this.shadowRows[j] = shadows[j] == 1;
                }
            }
        }
        for (int i = 0; i < 4; ++i) {
            String s = compound.getString("Text" + (i + 1));
            try {
                ITextComponent ichatcomponent = ITextComponent.Serializer.jsonToComponent((String)s);
                try {
                    this.signText[i] = TextComponentUtils.processComponent((ICommandSender)icommandsender, (ITextComponent)ichatcomponent, (Entity)null);
                }
                catch (CommandException var7) {
                    this.signText[i] = ichatcomponent;
                }
                continue;
            }
            catch (JsonParseException var8) {
                this.signText[i] = new TextComponentString(s);
            }
        }
        if (compound.hasKey(NBT_METAL_TAG)) {
            this.isMetal = compound.getBoolean(NBT_METAL_TAG);
        }
        if (compound.hasKey(NBT_TEXTURE_TAG)) {
            this.texture_name = compound.getString(NBT_TEXTURE_TAG);
        }
        if (this.texture_name == null || this.texture_name.isEmpty()) {
            this.texture_name = "oak_sign";
        }
        this.setResourceLocation(this.texture_name);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.getBlock() != newSate.getBlock();
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.writeToNBT(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
        this.markDirty();
    }

    public boolean getIsEditable() {
        return this.isEditable;
    }

    public void setEditAble(boolean state) {
        this.isEditable = state;
        if (!state) {
            this.playerEditing = null;
        }
    }

    public void setEditable(boolean editable) {
        this.setEditAble(editable);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(String texture) {
        if (this.worldObj != null && !this.worldObj.isRemote) {
            this.texture_name = texture;
        } else if (this.resourceLocation == null) {
            this.texture_name = texture;
            this.resourceLocation = Utils.getResourceLocation(texture, this.isMetal);
        }
    }

    public void setPlayer(EntityPlayer par1EntityPlayer) {
        this.playerEditing = par1EntityPlayer;
    }

    public EntityPlayer getPlayer() {
        return this.playerEditing;
    }

    public boolean canRenderBreaking() {
        return true;
    }
}

