/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.client.renderer;

import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityHPHorseBase;
import se.gory_moon.horsepower.util.RenderUtils;

public class ClientHandler {
    @SubscribeEvent
    public static void renderWorld(RenderWorldLastEvent event) {
        ItemStack[] itemStack = new ItemStack[]{ItemStack.EMPTY};
        if (Configs.client.showObstructedPlace && StreamSupport.stream(Minecraft.getMinecraft().player.getHeldEquipment().spliterator(), false).anyMatch(stack -> !stack.isEmpty() && ClientHandler.isHPBlock((itemStack[0] = stack).getItem()))) {
            Minecraft mc = Minecraft.getMinecraft();
            if (mc.objectMouseOver.typeOfHit != RayTraceResult.Type.BLOCK) {
                return;
            }
            int offset = 0;
            if (!itemStack[0].isEmpty() && ((ItemBlock)itemStack[0].getItem()).getBlock() instanceof BlockGrindstone) {
                offset = -1;
            }
            EnumFacing enumFacing = mc.objectMouseOver.sideHit;
            BlockPos pos = mc.objectMouseOver.getBlockPos();
            if (!mc.world.getBlockState(pos).getBlock().isReplaceable((IBlockAccess)mc.world, pos)) {
                pos = pos.offset(enumFacing);
            }
            if (offset == 0 && !mc.world.getBlockState(pos.up()).getBlock().isReplaceable((IBlockAccess)mc.world, pos.up())) {
                pos = pos.down();
            }
            RenderUtils.renderUsedArea((World)mc.world, pos, offset, 0.15f, 0.05f);
        }
    }

    private static boolean isHPBlock(Item item) {
        return item instanceof ItemBlock && ((ItemBlock)item).getBlock() instanceof BlockHPBase && TileEntityHPHorseBase.class.isAssignableFrom(((BlockHPBase)((ItemBlock)item).getBlock()).getTileClass());
    }
}

