/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockChoppingBlock;
import se.gory_moon.horsepower.blocks.BlockFiller;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.blocks.BlockHandGrindstone;
import se.gory_moon.horsepower.blocks.BlockPress;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;
import se.gory_moon.horsepower.tileentity.TileEntityFiller;
import se.gory_moon.horsepower.tileentity.TileEntityGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityHandGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityManualChopper;
import se.gory_moon.horsepower.tileentity.TileEntityPress;
import se.gory_moon.horsepower.util.Localization;

public class Provider
implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar registrar) {
        Provider provider = new Provider();
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockGrindstone.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockHandGrindstone.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockHPChoppingBase.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockPress.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockFiller.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockGrindstone.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockHandGrindstone.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockChopper.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockChoppingBlock.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockPress.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockFiller.class);
        registrar.addConfig("Horse Power", "horsepower:showItems", Localization.WAILA.SHOW_ITEMS.translate(new String[0]));
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock().equals((Object)ModBlocks.BLOCK_CHOPPER_FILLER)) {
            return accessor.getBlock().getPickBlock(accessor.getBlockState(), accessor.getMOP(), accessor.getWorld(), accessor.getPosition(), accessor.getPlayer());
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        IItemHandler itemHandler;
        TileEntity te;
        NBTTagCompound nbt = accessor.getNBTData();
        if (nbt.hasKey("horsepower:grindstone", 10)) {
            nbt = nbt.getCompoundTag("horsepower:grindstone");
            double total = nbt.getInteger("totalMillTime");
            double current = nbt.getInteger("millTime");
            double progress = (double)Math.round(current / total * 100.0 * 100.0) / 100.0;
            currenttip.add(Localization.WAILA.GRINDSTONE_PROGRESS.translate(String.valueOf(progress) + "%"));
        } else if (nbt.hasKey("horsepower:chopper", 10)) {
            nbt = nbt.getCompoundTag("horsepower:chopper");
            double totalWindup = Configs.general.pointsForWindup > 0 ? (double)Configs.general.pointsForWindup : 1.0;
            double windup = nbt.getInteger("currentWindup");
            double current = nbt.getInteger("chopTime");
            double total = nbt.getInteger("totalChopTime");
            double progressWindup = (double)Math.round(windup / totalWindup * 100.0 * 100.0) / 100.0;
            double progressChopping = (double)Math.round(current / total * 100.0 * 100.0) / 100.0;
            if (accessor.getTileEntity() instanceof TileEntityChopper || accessor.getTileEntity() instanceof TileEntityFiller) {
                currenttip.add(Localization.WAILA.WINDUP_PROGRESS.translate(String.valueOf(progressWindup) + "%"));
            }
            if (total > 1.0 || accessor.getTileEntity() instanceof TileEntityManualChopper) {
                currenttip.add(Localization.WAILA.CHOPPING_PROGRESS.translate(String.valueOf(progressChopping) + "%"));
            }
        } else if (nbt.hasKey("horsepower:press")) {
            nbt = nbt.getCompoundTag("horsepower:press");
            double current = nbt.getInteger("currentPressStatus");
            double total = Configs.general.pointsForPress > 0 ? (double)Configs.general.pointsForPress : 1.0;
            double progress = (double)Math.round(current / total * 100.0 * 100.0) / 100.0;
            currenttip.add(Localization.WAILA.PRESS_PROGRESS.translate(String.valueOf(progress) + "%"));
        }
        if (config.getConfig("horsepower:showItems") && (accessor.getTileEntity() instanceof TileEntityHPBase || accessor.getTileEntity() instanceof TileEntityFiller) && accessor.getPlayer().isSneaking() && (te = accessor.getTileEntity()).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP) && (itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) != null) {
            ItemStack stack = itemHandler.getStackInSlot(0);
            String name = String.valueOf(stack.getItem().getRegistryName().toString());
            if (!stack.isEmpty()) {
                currenttip.add(SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"1", name, String.valueOf(stack.getCount()), String.valueOf(stack.getItemDamage()), String.valueOf(stack.serializeNBT().toString())}) + TextFormatting.WHITE + stack.getDisplayName());
            }
            stack = itemHandler.getStackInSlot(1);
            name = String.valueOf(stack.getItem().getRegistryName().toString());
            if (!stack.isEmpty()) {
                currenttip.add(SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"1", name, String.valueOf(stack.getCount()), String.valueOf(stack.getItemDamage()), String.valueOf(stack.serializeNBT().toString())}) + TextFormatting.WHITE + stack.getDisplayName());
            }
            stack = itemHandler.getStackInSlot(2);
            name = String.valueOf(stack.getItem().getRegistryName().toString());
            if (!stack.isEmpty()) {
                currenttip.add(SpecialChars.getRenderString((String)"waila.stack", (String[])new String[]{"1", name, String.valueOf(stack.getCount()), String.valueOf(stack.getItemDamage()), String.valueOf(stack.serializeNBT().toString())}) + TextFormatting.WHITE + stack.getDisplayName());
            }
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        NBTTagCompound tile = new NBTTagCompound();
        if (te instanceof TileEntityFiller) {
            te = ((TileEntityFiller)te).getFilledTileEntity();
        }
        if (te != null) {
            te.writeToNBT(tile);
        }
        if (te instanceof TileEntityGrindstone || te instanceof TileEntityHandGrindstone) {
            tag.setTag("horsepower:grindstone", (NBTBase)tile);
        } else if (te instanceof TileEntityChopper || te instanceof TileEntityManualChopper) {
            tag.setTag("horsepower:chopper", (NBTBase)tile);
        } else if (te instanceof TileEntityPress) {
            tag.setTag("horsepower:press", (NBTBase)tile);
        }
        return tag;
    }
}

