/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.client.renderer;

import java.util.Arrays;
import java.util.stream.StreamSupport;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.client.renderer.FacingToRotation;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.util.Localization;

public abstract class TileEntityHPBaseRenderer<T extends TileEntityHPBase>
extends TileEntitySpecialRenderer<T> {
    private static TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];
    public static ITextComponent LEAD_LOOKUP = new TextComponentTranslation(Localization.INFO.ITEM_REVEAL.key(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));

    protected void renderStillItem(TileEntityHPBase te, ItemStack stack, float x, float y, float z, float scale) {
        this.renderItem(te, stack, x, y, z, scale, false);
    }

    protected void renderItem(TileEntityHPBase te, ItemStack stack, float x, float y, float z, float scale) {
        this.renderItem(te, stack, x, y, z, scale, true);
    }

    private void renderItem(TileEntityHPBase te, ItemStack stack, float x, float y, float z, float scale, boolean rotate) {
        RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
        if (stack != null) {
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
            EntityItem entityitem = new EntityItem(te.func_145831_w(), 0.0, 0.0, 0.0, stack.func_77946_l());
            entityitem.field_70290_d = 0.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            float rotation = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
            if (rotate) {
                GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)(0.5f * scale), (float)(0.5f * scale), (float)(0.5f * scale));
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            itemRenderer.func_181564_a(entityitem.func_92059_d(), ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    public void drawString(TileEntityHPBase te, String str, double x, double y, double z) {
        if (!this.canShowAmount(te)) {
            return;
        }
        this.func_190053_a(true);
        Entity entity = this.field_147501_a.field_147551_g;
        double d0 = te.func_145835_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (d0 <= 196.0) {
            float f = this.field_147501_a.field_147562_h;
            float f1 = this.field_147501_a.field_147563_i;
            FontRenderer fontRenderer = this.func_147498_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            if (te.getForward() == EnumFacing.EAST || te.getForward() == EnumFacing.WEST) {
                FacingToRotation.get(te.getForward().func_176734_d()).glRotateCurrentMat();
            } else {
                FacingToRotation.get(te.getForward()).glRotateCurrentMat();
            }
            GlStateManager.func_179114_b((float)(-f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)f1, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)-0.015f, (float)-0.015f, (float)0.015f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            fontRenderer.func_78276_b(str, -fontRenderer.func_78256_a(str) / 2, 0, -1);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
        this.func_190053_a(false);
    }

    public boolean canShowAmount(TileEntityHPBase te) {
        return Configs.client.renderItemAmount && (!Configs.client.mustLookAtBlock || this.field_147501_a.field_190057_j != null && te.func_174877_v().equals((Object)this.field_147501_a.field_190057_j.func_178782_a()));
    }

    protected void renderItemWithFacing(World world, TileEntityHPBase tile, ItemStack stack, double ox, double oy, double oz, float x, float y, float z, float scale) {
        if (stack.func_190926_b()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)ox, (double)oy, (double)oz);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        FacingToRotation.get(tile.getForward()).glRotateCurrentMat();
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        this.renderItem(tile, stack, x, y, z, scale);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)ox, (double)oy, (double)oz);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        FacingToRotation.get(tile.getForward()).glRotateCurrentMat();
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        this.drawString(tile, String.valueOf(stack.func_190916_E()), x, (double)y + 0.3, z);
        GlStateManager.func_179121_F();
    }

    protected void renderBaseModel(TileEntityHPBase te, Tessellator tessellator, BufferBuilder buffer, double x, double y, double z) {
        this.setRenderSettings();
        IBlockState blockState = te.func_145831_w().func_180495_p(te.func_174877_v());
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = dispatcher.func_184389_a(blockState);
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        buffer.func_178969_c((double)(-te.func_174877_v().func_177958_n()), (double)(-te.func_174877_v().func_177956_o()), (double)(-te.func_174877_v().func_177952_p()));
        dispatcher.func_175019_b().func_178267_a((IBlockAccess)te.func_145831_w(), model, blockState, te.func_174877_v(), buffer, false);
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    protected void renderBaseModelWithFacing(TileEntityHPBase te, IBlockState blockState, Tessellator tessellator, BufferBuilder buffer, double x, double y, double z, int destroyStage) {
        this.preDestroyRender(destroyStage);
        this.setRenderSettings();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = dispatcher.func_184389_a(blockState);
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        buffer.func_178969_c((double)(-te.func_174877_v().func_177958_n()), (double)(-te.func_174877_v().func_177956_o()), (double)(-te.func_174877_v().func_177952_p()));
        if (destroyStage >= 0) {
            buffer.func_78914_f();
            this.renderBlockDamage(blockState, te.func_174877_v(), TileEntityHPBaseRenderer.getDestroyBlockIcon(destroyStage), (IBlockAccess)te.func_145831_w());
        } else {
            dispatcher.func_175019_b().func_178267_a((IBlockAccess)te.func_145831_w(), model, blockState, te.func_174877_v(), buffer, false);
        }
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        FacingToRotation.get(te.getForward()).glRotateCurrentMat();
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        tessellator.func_78381_a();
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.postDestroyRender(destroyStage);
        RenderHelper.func_74519_b();
    }

    protected void setRenderSettings() {
        this.func_147499_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
    }

    protected void preDestroyRender(int destroyStage) {
        if (destroyStage >= 0) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
            GlStateManager.func_179088_q();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179141_d();
            GlStateManager.func_179094_E();
        }
    }

    protected void postDestroyRender(int destroyStage) {
        if (destroyStage >= 0) {
            GlStateManager.func_179118_c();
            GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
            GlStateManager.func_179113_r();
            GlStateManager.func_179141_d();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
            Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
            GlStateManager.func_179084_k();
        }
    }

    private double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    protected void renderLeash(EntityCreature entity, double ox, double oy, double oz, double x, double y, double z, float partialTicks, BlockPos pos) {
        if (entity != null) {
            oy -= 0.7;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = -1.0;
            double d9 = this.interpolateValue(entity.field_70760_ar, entity.field_70761_aq, partialTicks) * 0.01745329238474369 + 1.5707963267948966;
            d2 = Math.cos(d9) * (double)entity.field_70130_N * 0.4;
            d3 = Math.sin(d9) * (double)entity.field_70130_N * 0.4;
            double d6 = this.interpolateValue(entity.field_70169_q, entity.field_70165_t, partialTicks) + d2;
            double d7 = this.interpolateValue(entity.field_70167_r + (double)entity.func_70047_e() * 1.1, entity.field_70163_u + (double)entity.func_70047_e() * 1.1, partialTicks) - d4 * 0.5 - 0.25 - y;
            double d8 = this.interpolateValue(entity.field_70166_s, entity.field_70161_v, partialTicks) + d3;
            d2 = 0.5;
            d3 = 0.5;
            double d10 = (double)pos.func_177958_n() + d2;
            double d11 = pos.func_177956_o();
            double d12 = (double)pos.func_177952_p() + d3;
            this.renderLeach(d6, d7, d8, ox += d2 + x, oy += y, oz += d3 + z, d10, d11, d12);
        }
    }

    protected void renderLeach(double x1, double y1, double z1, double ox, double oy, double oz, double x2, double y2, double z2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        double d13 = (float)(x1 - x2);
        double d14 = (float)(y1 - y2);
        double d15 = (float)(z1 - z2);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (int j = 0; j <= 24; ++j) {
            float f = 0.5f;
            float f1 = 0.4f;
            float f2 = 0.3f;
            if (j % 2 == 0) {
                f *= 0.7f;
                f1 *= 0.7f;
                f2 *= 0.7f;
            }
            float f3 = (float)j / 24.0f;
            vertexbuffer.func_181662_b(ox + d13 * (double)f3 + 0.0, oy + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f), oz + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(ox + d13 * (double)f3 + 0.025, oy + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f) + 0.025, oz + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (int k = 0; k <= 24; ++k) {
            float f4 = 0.5f;
            float f5 = 0.4f;
            float f6 = 0.3f;
            if (k % 2 == 0) {
                f4 *= 0.7f;
                f5 *= 0.7f;
                f6 *= 0.7f;
            }
            float f7 = (float)k / 24.0f;
            vertexbuffer.func_181662_b(ox + d13 * (double)f7 + 0.0, oy + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f) + 0.025, oz + d15 * (double)f7).func_181666_a(f4, f5, f6, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(ox + d13 * (double)f7 + 0.025, oy + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f), oz + d15 * (double)f7 + 0.025).func_181666_a(f4, f5, f6, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
    }

    public void renderBlockDamage(IBlockState state, BlockPos pos, TextureAtlasSprite texture, IBlockAccess blockAccess) {
        state = state.func_185899_b(blockAccess, pos);
        IBakedModel ibakedmodel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        IBakedModel ibakedmodel1 = ForgeHooksClient.getDamageModel((IBakedModel)ibakedmodel, (TextureAtlasSprite)texture, (IBlockState)state, (IBlockAccess)blockAccess, (BlockPos)pos);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a(blockAccess, ibakedmodel1, state, pos, Tessellator.func_178181_a().func_178180_c(), true);
    }

    public static TextureAtlasSprite getDestroyBlockIcon(int destroyState) {
        if (destroyBlockIcons[destroyState] == null) {
            destroyBlockIcons = (TextureAtlasSprite[])ObfuscationReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)Minecraft.func_71410_x().field_71438_f, (String[])new String[]{"destroyBlockIcons", "field_94141_F"});
        }
        return destroyBlockIcons[destroyState];
    }

    public static void clearDestroyStageicons() {
        Arrays.stream(destroyBlockIcons).forEach(textureAtlasSprite -> {
            textureAtlasSprite = null;
        });
    }

    public void drawDisplayText(TileEntity te, double x, double y, double z) {
        ITextComponent itextcomponent = te.func_145748_c_();
        if (itextcomponent != null && this.field_147501_a.field_190057_j != null && te.func_174877_v().equals((Object)this.field_147501_a.field_190057_j.func_178782_a())) {
            this.func_190053_a(true);
            this.drawCustomNameplate(te, itextcomponent.func_150254_d(), x, y, z, 12, 0.0f);
            this.drawCustomNameplate(te, LEAD_LOOKUP.func_150254_d(), x, y, z, 12, -0.25f);
            this.func_190053_a(false);
        }
    }

    protected void drawCustomNameplate(TileEntity te, String str, double x, double y, double z, int maxDistance, float offset) {
        Entity entity = this.field_147501_a.field_147551_g;
        double d0 = te.func_145835_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (d0 <= (double)(maxDistance * maxDistance)) {
            float f = this.field_147501_a.field_147562_h;
            float f1 = this.field_147501_a.field_147563_i;
            EntityRenderer.func_189692_a((FontRenderer)this.func_147498_b(), (String)str, (float)((float)x + 0.5f), (float)((float)y + 1.5f + offset), (float)((float)z + 0.5f), (int)0, (float)f, (float)f1, (boolean)false, (boolean)false);
        }
    }

    public static void renderInvalidArea(World world, BlockPos blockPos, int yOffset) {
        if (StreamSupport.stream(Minecraft.func_71410_x().field_71439_g.func_184214_aD().spliterator(), false).anyMatch(stack -> !stack.func_190926_b() && stack.func_77973_b() == Items.field_151058_ca)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2848);
            GlStateManager.func_179126_j();
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179136_a((float)-0.1f, (float)-10.0f);
            GlStateManager.func_179088_q();
            for (int xo = -3; xo <= 3; ++xo) {
                for (int yo = yOffset; yo <= 1 + yOffset; ++yo) {
                    for (int zo = -3; zo <= 3; ++zo) {
                        BlockPos pos = blockPos.func_177982_a(xo, yo, zo);
                        if (xo <= 1 && xo >= -1 && zo <= 1 && zo >= -1 || pos.func_177956_o() < 0) continue;
                        IBlockState state = world.func_180495_p(pos);
                        if (!state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)0.55f);
                            TileEntityHPBaseRenderer.drawBoundingBoxOutline(new AxisAlignedBB(pos).func_72317_d(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n));
                            TileEntityHPBaseRenderer.drawBoundingBox(state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos).func_72317_d(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n));
                            continue;
                        }
                        GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)0.15f);
                        TileEntityHPBaseRenderer.drawBoundingBoxOutline(new AxisAlignedBB(pos).func_72317_d(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n));
                    }
                }
            }
            GlStateManager.func_179113_r();
            GL11.glDisable((int)2848);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBoundingBox(AxisAlignedBB axisalignedbb) {
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glEnd();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBoundingBoxOutline(AxisAlignedBB par1AxisAlignedBB) {
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glEnd();
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glEnd();
    }
}

