/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.recipes;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;

public class ShapedChoppingRecipe
extends ShapedOreRecipe {
    public final List<ItemStack> outputBlocks;

    public ShapedChoppingRecipe(ResourceLocation location, List<ItemStack> variantItems, ItemStack result, Object ... recipe) {
        super(location, result, recipe);
        this.outputBlocks = variantItems;
        for (ItemStack stack : this.outputBlocks) {
            if (!(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockHPChoppingBase)) continue;
            for (int i = 0; i < this.input.size(); ++i) {
                Ingredient ingredient = (Ingredient)this.input.get(i);
                if (!ingredient.apply(stack)) continue;
                NonNullList stacks = NonNullList.func_191196_a();
                Block.func_149634_a((Item)stack.func_77973_b()).func_149666_a(null, stacks);
                this.input.set(i, (Object)Ingredient.func_193369_a((ItemStack[])((ItemStack[])stacks.toArray((Object[])new ItemStack[stacks.size()]))));
            }
        }
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting craftMatrix) {
        boolean isTypeChopping = false;
        for (ItemStack outputBlock : this.outputBlocks) {
            if (!(((ItemBlock)outputBlock.func_77973_b()).func_179223_d() instanceof BlockHPChoppingBase)) continue;
            isTypeChopping = true;
        }
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            for (ItemStack ore : this.outputBlocks) {
                ItemStack stack;
                if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)(stack = craftMatrix.func_70301_a(i)), (boolean)false) && (!isTypeChopping || !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockHPChoppingBase)) || Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a) continue;
                BlockHPChoppingBase block = (BlockHPChoppingBase)Block.func_149634_a((Item)this.getSimpleRecipeOutput().func_77973_b());
                if (!Configs.general.useDynamicCrafting) {
                    if ("minecraft".equals(ore.func_77973_b().getRegistryName().func_110624_b())) {
                        return BlockHPChoppingBase.createItemStack(block, this.getSimpleRecipeOutput().func_190916_E(), stack);
                    }
                    return BlockHPChoppingBase.createItemStack(block, this.getSimpleRecipeOutput().func_190916_E(), new ItemStack(Blocks.field_150364_r, 1, 0));
                }
                return BlockHPChoppingBase.createItemStack(block, this.getSimpleRecipeOutput().func_190916_E(), stack);
            }
        }
        return super.func_77572_b(craftMatrix);
    }

    @Nonnull
    public ItemStack func_77571_b() {
        if (!this.outputBlocks.isEmpty() && !this.output.func_190926_b()) {
            ItemStack stack = this.outputBlocks.get(0).func_77946_l();
            BlockHPChoppingBase block = (BlockHPChoppingBase)Block.func_149634_a((Item)this.output.func_77973_b());
            int meta = stack.func_77960_j();
            if (meta == Short.MAX_VALUE) {
                stack.func_77964_b(0);
            }
            return BlockHPChoppingBase.createItemStack(block, this.getSimpleRecipeOutput().func_190916_E(), stack);
        }
        return super.func_77571_b();
    }

    public ItemStack getSimpleRecipeOutput() {
        return this.output;
    }
}

