/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.util;

import com.google.common.collect.Lists;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.IClientCommand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HorsePowerCommand
extends CommandBase
implements IClientCommand {
    public String getName() {
        return "horsepower";
    }

    public String getUsage(ICommandSender sender) {
        return "commands.horsepower.usage";
    }

    public List<String> getAliases() {
        return Lists.newArrayList((Object[])new String[]{"hp"});
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            if ("entity".equals(args[0])) {
                if (sender instanceof EntityPlayerSP) {
                    RayTraceResult result = Minecraft.getMinecraft().objectMouseOver;
                    if (result != null && result.typeOfHit == RayTraceResult.Type.ENTITY) {
                        Entity entity = result.entityHit;
                        sender.sendMessage((ITextComponent)new TextComponentTranslation("commands.horsepower.entity.has", new Object[]{entity.getClass().getName()}));
                        try {
                            StringSelection selection = new StringSelection(entity.getClass().getName());
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
                        }
                        catch (Exception exception) {}
                    } else {
                        sender.sendMessage((ITextComponent)new TextComponentTranslation("commands.horsepower.entity.no", new Object[0]));
                    }
                } else {
                    throw new CommandException("commands.horsepower.entity.invalid", new Object[0]);
                }
                return;
            }
            if ("reload".equals(args[0])) {
                throw new CommandException("commands.horsepower.reload", new Object[0]);
            }
        }
        throw new WrongUsageException(this.getUsage(sender), new Object[0]);
    }

    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return args.length == 1 ? HorsePowerCommand.getListOfStringsMatchingLastWord((String[])args, (String[])new String[]{"entity"}) : Collections.emptyList();
    }

    public boolean allowUsageWithoutPrefix(ICommandSender sender, String message) {
        return false;
    }
}

