/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.network.PacketHandler;
import se.gory_moon.horsepower.network.messages.SyncServerRecipesMessage;
import se.gory_moon.horsepower.recipes.HPRecipes;

@Mod.EventBusSubscriber(modid="horsepower")
public class EventHandler {
    public static List<ItemStack> choppingAxes = new ArrayList<ItemStack>();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("horsepower")) {
            ConfigManager.sync((String)"horsepower", (Config.Type)Config.Type.INSTANCE);
            HPRecipes.instance().reloadRecipes();
            choppingAxes = Arrays.stream(Configs.general.choppingBlockAxes).map(s -> {
                Item item;
                String[] data = s.split(":");
                if (data.length >= 2 && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(data[0] + ":" + data[1]))) != null) {
                    int meta = 0;
                    if (data.length == 3) {
                        meta = Integer.parseInt(data[2]);
                    }
                    return new ItemStack(item, 1, meta);
                }
                return ItemStack.field_190927_a;
            }).collect(Collectors.toList());
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(EntityJoinWorldEvent event) {
        if (FMLCommonHandler.instance().getSide().isClient() && event.getEntity() instanceof EntityPlayerSP && event.getWorld() instanceof WorldClient && FMLClientHandler.instance().getClientPlayerEntity() != null && HPRecipes.ERRORS.size() > 0) {
            HPRecipes.ERRORS.forEach(s -> FMLClientHandler.instance().getClientPlayerEntity().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + s)));
            HPRecipes.ERRORS.clear();
        }
    }

    @SubscribeEvent
    public static void onServerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            PacketHandler.INSTANCE.sendTo((IMessage)new SyncServerRecipesMessage(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onServerLeave(WorldEvent.Unload event) {
        NetworkManager manager;
        if (FMLCommonHandler.instance().getSide().isClient() && (manager = FMLClientHandler.instance().getClientToServerNetworkManager()) != null && !manager.func_150731_c() && HPRecipes.serverSyncedRecipes) {
            HPRecipes.serverSyncedRecipes = false;
            HPRecipes.instance().reloadRecipes();
        }
    }
}

