/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.advancements.Manager;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.blocks.property.PropertyUnlistedString;
import se.gory_moon.horsepower.client.renderer.modelvariants.ChopperModels;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.color.Colors;

@Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoAccessor", modid="theoneprobe")
public class BlockChopper
extends BlockHPBase
implements IProbeInfoAccessor {
    public static final PropertyDirection FACING = PropertyDirection.func_177713_a((String)"facing", Arrays.asList(EnumFacing.field_176754_o));
    public static final PropertyEnum<ChopperModels> PART = PropertyEnum.func_177709_a((String)"part", ChopperModels.class);
    public static final PropertyUnlistedString SIDE_TEXTURE = new PropertyUnlistedString("side_texture");
    public static final PropertyUnlistedString TOP_TEXTURE = new PropertyUnlistedString("top_texture");
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);

    public BlockChopper() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setRegistryName("chopper");
        this.func_149663_c("chopper");
        this.func_149647_a(HorsePowerMod.creativeTab);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityChopper();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return COLLISION_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{PART, FACING}, new IUnlistedProperty[]{SIDE_TEXTURE, TOP_TEXTURE});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        TileEntityHPBase tile = this.getTileEntity(world, pos);
        if (tile != null && tile instanceof TileEntityChopper) {
            return ((TileEntityChopper)tile).getExtendedState(extendedState);
        }
        return super.getExtendedState(state, world, pos);
    }

    private void writeDataOntoItemstack(@Nonnull ItemStack item, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean inventorySave) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityChopper) {
            TileEntityChopper table = (TileEntityChopper)te;
            NBTTagCompound tag = item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound();
            NBTTagCompound data = table.getTextureBlock();
            if (!data.func_82582_d()) {
                tag.func_74782_a("textureBlock", (NBTBase)data);
            }
            if (!tag.func_82582_d()) {
                item.func_77982_d(tag);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Item item = this.func_180660_a(state, world.field_73012_v, 0);
        if (item != Items.field_190931_a) {
            drops.add(new ItemStack(item, 1, this.func_180651_a(state)));
        }
        if (drops.size() > 0) {
            ItemStack stack = (ItemStack)drops.get(0);
            this.writeDataOntoItemstack(stack, (IBlockAccess)world, pos, state, false);
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : items) {
                if (item.func_77973_b() != Item.func_150898_a((Block)this)) continue;
                this.writeDataOntoItemstack(item, (IBlockAccess)worldIn, pos, state, chance >= 1.0f);
            }
            for (ItemStack item : items) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockChopper.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(PART, (Comparable)((Object)ChopperModels.BASE)), 2);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(PART, (Comparable)((Object)ChopperModels.BASE));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(PART, (Comparable)((Object)ChopperModels.BASE));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TileEntityHPBase tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        NBTTagCompound baseTag = tag != null ? tag.func_74775_l("textureBlock") : new NBTTagCompound();
        ((TileEntityChopper)tile).setTextureBlock(baseTag);
        tile.setForward(placer.func_174811_aO().func_176734_d());
    }

    @Override
    public void emptiedOutput(World world, BlockPos pos) {
    }

    @Override
    public void onWorkerAttached(EntityPlayer playerIn, EntityCreature creature) {
        if (playerIn instanceof EntityPlayerMP) {
            Manager.USE_CHOPPER.trigger((EntityPlayerMP)playerIn);
        }
    }

    public static ItemStack createItemStack(BlockChopper table, Block block, int blockMeta) {
        ItemStack stack = new ItemStack((Block)table, 1);
        if (block != null) {
            ItemStack blockStack = new ItemStack(block, 1, blockMeta);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound subTag = new NBTTagCompound();
            blockStack.func_77955_b(subTag);
            tag.func_74782_a("textureBlock", (NBTBase)subTag);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (ItemStack stack : OreDictionary.getOres((String)"logWood")) {
            Block block = BlockChopper.func_149634_a((Item)stack.func_77973_b());
            int blockMeta = stack.func_77952_i();
            if (blockMeta == Short.MAX_VALUE) {
                NonNullList subBlocks = NonNullList.func_191196_a();
                block.func_149666_a(null, subBlocks);
                for (ItemStack subBlock : subBlocks) {
                    items.add((Object)BlockChopper.createItemStack(this, BlockChopper.func_149634_a((Item)subBlock.func_77973_b()), subBlock.func_77952_i()));
                }
                continue;
            }
            items.add((Object)BlockChopper.createItemStack(this, block, blockMeta));
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.SIZE.translate(Colors.WHITE.toString(), Colors.LIGHTGRAY.toString()));
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.LOCATION.translate(new String[0]));
        tooltip.add(Localization.ITEM.HORSE_CHOPPING.USE.translate(new String[0]));
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity = world.func_175625_s(data.getPos());
        if (tileEntity instanceof TileEntityChopper) {
            TileEntityChopper te = (TileEntityChopper)tileEntity;
            double totalWindup = Configs.pointsForWindup > 0 ? (double)Configs.pointsForWindup : 1.0;
            probeInfo.progress((long)((double)te.getField(2) / totalWindup * 100.0), 100L, (IProgressStyle)new ProgressStyle().prefix(Localization.TOP.WINDUP_PROGRESS.translate(new String[0]) + " ").suffix("%"));
            if (te.getField(0) > 1) {
                probeInfo.progress((long)((double)te.getField(1) / (double)te.getField(0) * 100.0), 100L, (IProgressStyle)new ProgressStyle().prefix(Localization.TOP.CHOPPING_PROGRESS.translate(new String[0]) + " ").suffix("%"));
            }
        }
    }
}

