/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.client.model.modelvariants.PressModels;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityPress;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.color.Colors;

@Optional.Interface(iface="mcjty.theoneprobe.api.IProbeInfoAccessor", modid="theoneprobe")
public class BlockPress
extends BlockHPBase
implements IProbeInfoAccessor {
    public static final PropertyDirection FACING = PropertyDirection.create((String)"facing", Arrays.asList(EnumFacing.HORIZONTALS));
    public static final PropertyEnum<PressModels> PART = PropertyEnum.create((String)"part", PressModels.class);
    private static final AxisAlignedBB BOUND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.75, 1.0);
    private static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.1875, 1.0);

    public BlockPress() {
        super(Material.ROCK);
        this.setHardness(5.0f);
        this.setResistance(5.0f);
        this.setHarvestLevel("axe", 1);
        this.setSoundType(SoundType.WOOD);
        this.setRegistryName("press");
        this.setUnlocalizedName("press");
        this.setCreativeTab(HorsePowerMod.creativeTab);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUND_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.isRemote) {
            EnumFacing filled = (EnumFacing)state.getValue((IProperty)FACING);
            worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)filled).withProperty(PART, (Comparable)((Object)PressModels.BASE)), 2);
        }
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityPress();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PART});
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()).withProperty(PART, (Comparable)((Object)PressModels.BASE));
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.getHorizontal((int)meta)).withProperty(PART, (Comparable)((Object)PressModels.BASE));
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()), 2);
        Object tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        ((TileEntityHPBase)((Object)tile)).setForward(placer.getHorizontalFacing().getOpposite());
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack);
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntityPress tileEntity = (TileEntityPress)((Object)this.getTileEntity((IBlockAccess)world, data.getPos()));
        if (tileEntity != null) {
            probeInfo.progress((long)((double)tileEntity.getField(0) / (double)(Configs.general.pointsForPress > 0 ? Configs.general.pointsForPress : 1) * 100.0), 100L, (IProgressStyle)new ProgressStyle().prefix(Localization.TOP.PRESS_PROGRESS.translate(new String[0]) + " ").suffix("%"));
        }
    }

    @Override
    public void emptiedOutput(World world, BlockPos pos) {
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(Localization.ITEM.HORSE_PRESS.SIZE.translate(Colors.WHITE.toString(), Colors.LIGHTGRAY.toString()));
        tooltip.add(Localization.ITEM.HORSE_PRESS.LOCATION.translate(new String[0]));
        tooltip.add(Localization.ITEM.HORSE_PRESS.USE.translate(new String[0]));
    }

    @Override
    @Nonnull
    public Class<?> getTileClass() {
        return TileEntityPress.class;
    }
}

