/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tweaker.recipes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.recipes.PressRecipe;
import se.gory_moon.horsepower.tweaker.TweakerPluginImpl;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.horsepower.Press")
public class PressRecipeTweaker {
    @ZenMethod
    public static void add(IIngredient input, IItemStack output) {
        List items = input.getItems();
        if (items == null) {
            HorsePowerMod.logger.error("Cannot turn " + input.toString() + " into a press recipe");
        }
        ItemStack[] items2 = MineTweakerMC.getItemStacks((List)items);
        ItemStack output2 = MineTweakerMC.getItemStack((IItemStack)output);
        AddPressRecipe recipe = new AddPressRecipe(input, items2, output2, ItemStack.EMPTY, 0, 0);
        MineTweakerAPI.apply((IUndoableAction)recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        ArrayList toRemove = Lists.newArrayList();
        ArrayList removeIndex = Lists.newArrayList();
        for (int i = 0; i < HPRecipes.instance().getGrindstoneRecipes().size(); ++i) {
            PressRecipe recipe = HPRecipes.instance().getPressRecipes().get(i);
            if (!OreDictionary.itemMatches((ItemStack)MineTweakerMC.getItemStack((IIngredient)output), (ItemStack)recipe.getOutput(), (boolean)false)) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        RemovePressRecipe recipe = new RemovePressRecipe(toRemove, removeIndex);
        MineTweakerAPI.apply((IUndoableAction)recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    private static class RemovePressRecipe
    implements IUndoableAction {
        private final List<Integer> removingIndices;
        private final List<PressRecipe> recipes;

        private RemovePressRecipe(List<PressRecipe> recipes, List<Integer> removingIndices) {
            this.recipes = recipes;
            this.removingIndices = removingIndices;
        }

        public void apply() {
            ArrayList<PressRecipe> recipeList = HPRecipes.instance().getPressRecipes();
            for (int i = this.removingIndices.size() - 1; i >= 0; --i) {
                recipeList.remove(this.removingIndices.get(i));
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipes.get(i), "horsepower.press");
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            ArrayList<PressRecipe> recipeList = HPRecipes.instance().getPressRecipes();
            for (int i = 0; i < this.removingIndices.size(); ++i) {
                int index = Math.min(recipeList.size(), this.removingIndices.get(i));
                recipeList.add(index, this.recipes.get(i));
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipes.get(i), "horsepower.press");
            }
            TweakerPluginImpl.actions.remove(this);
        }

        public String describe() {
            return "Removing " + this.recipes.size() + " press recipes";
        }

        public String describeUndo() {
            return "Restoring " + this.recipes.size() + " press recipes";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddPressRecipe
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final ItemStack[] input;
        private final ItemStack output;
        private final ItemStack secondary;
        private final int secondaryChance;
        private final int time;

        public AddPressRecipe(IIngredient ingredient, ItemStack[] inputs, ItemStack output2, ItemStack secondary, int secondaryChance, int time) {
            this.ingredient = ingredient;
            this.input = inputs;
            this.output = output2;
            this.secondary = secondary;
            this.secondaryChance = secondaryChance;
            this.time = time;
        }

        public void apply() {
            for (ItemStack stack : this.input) {
                PressRecipe recipe = new PressRecipe(stack, this.output, this.secondary, this.secondary.isEmpty() ? 0 : this.secondaryChance, this.time);
                HPRecipes.instance().addPressRecipe(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe, "horsepower.press");
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack stack : this.input) {
                PressRecipe recipe = HPRecipes.instance().getPressRecipe(stack);
                HPRecipes.instance().removePressRecipe(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe, "horsepower.press");
            }
            TweakerPluginImpl.actions.remove(this);
        }

        public String describe() {
            return "Adding press recipe for " + this.ingredient;
        }

        public String describeUndo() {
            return "Removing press recipe for " + this.ingredient;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

