/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.ITickTimer;
import net.minecraft.client.Minecraft;

public class HorseDrawable
implements IDrawableAnimated {
    private final IDrawableStatic horse1;
    private final IDrawableStatic horse2;
    private final IDrawableStatic horse3;
    private final IDrawableStatic horse4;
    private final ITickTimer animTimer;
    private final ITickTimer pathTimer;
    private final boolean grinding;
    private boolean reverse;
    private int location;
    private int x;
    private int y;
    private String hovering;

    public HorseDrawable(IGuiHelper guiHelper, IDrawableStatic horse1, IDrawableStatic horse2, IDrawableStatic horse3, IDrawableStatic horse4, ITickTimer animTimer, ITickTimer pathTimer, boolean grinding, String hovering) {
        this.horse1 = horse1;
        this.horse2 = horse2;
        this.horse3 = horse3;
        this.horse4 = horse4;
        this.grinding = grinding;
        this.animTimer = animTimer;
        this.pathTimer = pathTimer;
        this.hovering = hovering;
    }

    public int getWidth() {
        return 30;
    }

    public int getHeight() {
        return 20;
    }

    public void draw(Minecraft minecraft) {
        this.draw(minecraft, 0, 0);
    }

    public void draw(Minecraft minecraft, int xOffset, int yOffset) {
        this.reverse = false;
        this.location = this.pathTimer.getValue();
        this.setXYPos();
        IDrawableStatic draw = this.animTimer.getValue() == 0 ? (this.reverse ? this.horse3 : this.horse1) : (this.reverse ? this.horse4 : this.horse2);
        draw.draw(minecraft, xOffset + this.x, yOffset + this.y, 0, 0, 0, 0);
    }

    private void setXYPos() {
        if (this.grinding) {
            if (this.location <= 112) {
                this.x = this.location;
                this.y = 0;
            } else if (this.location <= 176) {
                this.x = 112;
                this.y = this.location - 112;
                this.reverse = true;
            } else if (this.location <= 288) {
                this.x = 112 - (this.location - 174);
                this.y = 64;
                this.reverse = true;
            } else {
                this.x = 0;
                this.y = 64 - (this.location - 288);
            }
        } else if (this.location <= 112) {
            this.x = this.location;
            this.y = 0;
        } else if (this.location <= 162) {
            this.x = 112;
            this.y = this.location - 112;
            this.reverse = true;
        } else if (this.location <= 274) {
            this.x = 112 - (this.location - 160);
            this.y = 50;
            this.reverse = true;
        } else {
            this.x = 0;
            this.y = 50 - (this.location - 274);
        }
    }

    private boolean isHovering(int mx, int my) {
        return mx >= this.x && mx <= this.x + this.horse1.getWidth() && my >= this.y && my <= this.y + this.horse1.getHeight();
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        this.setXYPos();
        return this.isHovering(mouseX, mouseY) && this.hovering != null ? Lists.newArrayList((Iterable)Splitter.on((char)'\n').split((CharSequence)this.hovering)) : Collections.emptyList();
    }
}

