/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.client.renderer;

import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public enum FacingToRotation {
    DOWN(new javax.vecmath.Vector3f(0.0f, 0.0f, 0.0f)),
    UP(new javax.vecmath.Vector3f(0.0f, 0.0f, 0.0f)),
    NORTH(new javax.vecmath.Vector3f(0.0f, 0.0f, 0.0f)),
    SOUTH(new javax.vecmath.Vector3f(0.0f, 180.0f, 0.0f)),
    WEST(new javax.vecmath.Vector3f(0.0f, 90.0f, 0.0f)),
    EAST(new javax.vecmath.Vector3f(0.0f, -90.0f, 0.0f));

    private final javax.vecmath.Vector3f rot;
    private final Matrix4f mat;

    private FacingToRotation(javax.vecmath.Vector3f rot) {
        this.rot = rot;
        this.mat = TRSRTransformation.toVecmath((org.lwjgl.util.vector.Matrix4f)new org.lwjgl.util.vector.Matrix4f().rotate((float)Math.toRadians(rot.x), new Vector3f(1.0f, 0.0f, 0.0f)).rotate((float)Math.toRadians(rot.y), new Vector3f(0.0f, 1.0f, 0.0f)).rotate((float)Math.toRadians(rot.z), new Vector3f(0.0f, 0.0f, 1.0f)));
    }

    public javax.vecmath.Vector3f getRot() {
        return this.rot;
    }

    public Matrix4f getMat() {
        return new Matrix4f(this.mat);
    }

    public void glRotateCurrentMat() {
        GlStateManager.rotate((float)this.rot.x, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotate((float)this.rot.y, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)this.rot.z, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public EnumFacing rotate(EnumFacing facing) {
        return TRSRTransformation.rotate((Matrix4f)this.mat, (EnumFacing)facing);
    }

    public EnumFacing resultingRotate(EnumFacing facing) {
        for (EnumFacing face : EnumFacing.values()) {
            if (this.rotate(face) != facing) continue;
            return face;
        }
        return null;
    }

    public static FacingToRotation get(EnumFacing forward) {
        return FacingToRotation.values()[forward.ordinal()];
    }
}

