/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.recipes.GrindstoneRecipes;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.Utils;

public class TileEntityGrindstone
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    private NonNullList<ItemStack> millItemStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private static double[][] path = new double[][]{{-1.5, -1.5}, {0.0, -1.5}, {1.0, -1.5}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {-1.5, 1.0}, {-1.5, 0.0}};
    private AxisAlignedBB[] searchAreas = new AxisAlignedBB[8];
    private List<BlockPos> searchPos = null;
    private int origin;
    private int target = this.origin = -1;
    private boolean hasWorker = false;
    private EntityCreature worker;
    private NBTTagCompound nbtWorker;
    private int currentItemMillTime;
    private int totalItemMillTime;
    private boolean running = true;
    private boolean wasRunning = false;
    private boolean valid = false;
    private int validationTimer = 0;
    private IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);

    public void setWorker(EntityCreature newWorker) {
        this.hasWorker = true;
        this.worker = newWorker;
        this.worker.func_175449_a(this.field_174879_c, 3);
        this.target = this.getClosestTarget();
    }

    public void setWorkerToPlayer(EntityPlayer player) {
        if (this.hasWorker() && this.worker.func_184652_a(player)) {
            this.hasWorker = false;
            this.worker.func_110177_bN();
            this.worker.func_110162_b((Entity)player, true);
            this.worker = null;
        }
    }

    public boolean hasWorker() {
        if (this.worker != null && !this.worker.field_70128_L && !this.worker.func_110167_bD() && this.worker.func_174818_b(this.field_174879_c) < 45.0) {
            return true;
        }
        if (this.worker != null) {
            this.worker = null;
            if (!this.func_145831_w().field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), (ItemStack)new ItemStack(Items.field_151058_ca));
            }
        }
        this.hasWorker = false;
        return false;
    }

    public EntityCreature getWorker() {
        return this.worker;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        if (this.valid) {
            return super.func_145748_c_();
        }
        return new TextComponentTranslation(Localization.INFO.GRINDSTONE_INVALID.key(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.millItemStacks);
        compound.func_74768_a("millTime", this.currentItemMillTime);
        compound.func_74768_a("totalMillTime", this.totalItemMillTime);
        compound.func_74768_a("target", this.target);
        compound.func_74768_a("origin", this.origin);
        compound.func_74757_a("hasWorker", this.hasWorker);
        if (this.worker != null) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            UUID uuid = this.worker.func_110124_au();
            nbtTagCompound.func_186854_a("UUID", uuid);
            compound.func_74782_a("leash", (NBTBase)nbtTagCompound);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.millItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.millItemStacks);
        if (this.func_70301_a(0).func_190916_E() > 0) {
            this.currentItemMillTime = compound.func_74762_e("millTime");
            this.totalItemMillTime = compound.func_74762_e("totalMillTime");
        } else {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = 1;
        }
        this.target = compound.func_74762_e("target");
        this.origin = compound.func_74762_e("origin");
        this.hasWorker = compound.func_74767_n("hasWorker");
        if (this.hasWorker && compound.func_150297_b("leash", 10)) {
            this.nbtWorker = compound.func_74775_l("leash");
        }
    }

    public void notifyUpdate() {
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -999, this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void func_70296_d() {
        if (((ItemStack)this.millItemStacks.get(1)).func_190926_b()) {
            BlockGrindstone.setState(false, this.field_145850_b, this.field_174879_c);
        }
        super.func_70296_d();
        this.notifyUpdate();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
        this.func_70296_d();
    }

    private boolean validateArea() {
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x == 0 && z == 0) continue;
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, 0, z));
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, -1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            if (this.func_145831_w().func_175623_d(pos)) continue;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        boolean flag = false;
        --this.validationTimer;
        if (this.validationTimer <= 0) {
            this.valid = this.validateArea();
            this.validationTimer = this.valid ? 220 : 60;
        }
        if (this.nbtWorker != null) {
            if (this.hasWorker) {
                UUID uuid = this.nbtWorker.func_186857_a("UUID");
                int x = this.field_174879_c.func_177958_n();
                int y = this.field_174879_c.func_177956_o();
                int z = this.field_174879_c.func_177952_p();
                ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
                block0: for (Class<? extends EntityCreature> clazz : clazzes) {
                    for (Object entity : this.field_145850_b.func_72872_a(clazz, new AxisAlignedBB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0))) {
                        EntityCreature creature;
                        if (!(entity instanceof EntityCreature) || !(creature = (EntityCreature)entity).func_110124_au().equals(uuid)) continue;
                        this.setWorker(creature);
                        break block0;
                    }
                }
            }
            this.nbtWorker = null;
        }
        if (!this.field_145850_b.field_72995_K && this.valid) {
            if (!this.running && this.canMill()) {
                this.running = true;
            } else if (this.running && !this.canMill()) {
                this.running = false;
            }
            if (this.running != this.wasRunning) {
                this.target = this.getClosestTarget();
                this.wasRunning = this.running;
            }
            if (this.hasWorker() && this.running) {
                double x = (double)this.field_174879_c.func_177958_n() + path[this.target][0] * 2.0;
                double y = this.field_174879_c.func_177956_o() - 1;
                double z = (double)this.field_174879_c.func_177952_p() + path[this.target][1] * 2.0;
                if (this.searchAreas[this.target] == null) {
                    this.searchAreas[this.target] = new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5);
                }
                if (this.worker.func_174813_aQ().func_72326_a(this.searchAreas[this.target])) {
                    int next = this.target + 1;
                    int previous = this.target - 1;
                    if (next >= path.length) {
                        next = 0;
                    }
                    if (previous < 0) {
                        previous = path.length - 1;
                    }
                    if (this.origin != this.target && this.target != previous) {
                        this.origin = this.target;
                        ++this.currentItemMillTime;
                        if (this.currentItemMillTime == this.totalItemMillTime) {
                            this.currentItemMillTime = 0;
                            this.totalItemMillTime = GrindstoneRecipes.instance().getGrindstoneTime((ItemStack)this.millItemStacks.get(0));
                            this.millItem();
                            flag = true;
                        }
                    }
                    this.target = next;
                }
                if (this.worker instanceof AbstractHorse && ((AbstractHorse)this.worker).func_110204_cc()) {
                    ((AbstractHorse)this.worker).func_110227_p(false);
                }
                if (this.target != -1 && this.worker.func_70661_as().func_75500_f()) {
                    x = (double)this.field_174879_c.func_177958_n() + path[this.target][0] * 2.0;
                    y = this.field_174879_c.func_177956_o() - 1;
                    z = (double)this.field_174879_c.func_177952_p() + path[this.target][1] * 2.0;
                    this.worker.func_70661_as().func_75492_a(x, y, z, 1.0);
                }
            }
        }
        if (flag) {
            this.func_70296_d();
        }
    }

    private int getClosestTarget() {
        if (this.hasWorker()) {
            double dist = Double.MAX_VALUE;
            int closest = 0;
            for (int i = 0; i < path.length; ++i) {
                double z;
                double y;
                double x = (double)this.field_174879_c.func_177958_n() + path[i][0] * 2.0;
                double tmp = this.worker.func_70011_f(x, y = (double)(this.field_174879_c.func_177956_o() - 1), z = (double)this.field_174879_c.func_177952_p() + path[i][1] * 2.0);
                if (!(tmp < dist)) continue;
                dist = tmp;
                closest = i;
            }
            return closest;
        }
        return 0;
    }

    private void millItem() {
        if (this.canMill()) {
            ItemStack input = (ItemStack)this.millItemStacks.get(0);
            ItemStack result = GrindstoneRecipes.instance().getGrindstoneResult((ItemStack)this.millItemStacks.get(0));
            ItemStack output = (ItemStack)this.millItemStacks.get(1);
            if (output.func_190926_b()) {
                this.millItemStacks.set(1, (Object)result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            input.func_190918_g(1);
            BlockGrindstone.setState(true, this.field_145850_b, this.field_174879_c);
        }
    }

    private boolean canMill() {
        if (((ItemStack)this.millItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = GrindstoneRecipes.instance().getGrindstoneResult((ItemStack)this.millItemStacks.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack output = (ItemStack)this.millItemStacks.get(1);
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(itemstack)) {
            return false;
        }
        int result = output.func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= output.func_77976_d();
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && stack1.func_190916_E() <= stack1.func_77976_d() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : new int[]{});
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN && index == 1;
    }

    public int func_70302_i_() {
        return this.millItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.millItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.millItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.millItemStacks, (int)index, (int)count);
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStackHelper.func_188383_a(this.millItemStacks, (int)index);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.millItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.millItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 1 && ((ItemStack)this.millItemStacks.get(1)).func_190926_b()) {
            BlockGrindstone.setState(false, this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
        }
        if (index == 0 && !flag) {
            this.totalItemMillTime = GrindstoneRecipes.instance().getGrindstoneTime(stack);
            this.currentItemMillTime = 0;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1 && index == 0 && GrindstoneRecipes.instance().hasRecipe(stack);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.totalItemMillTime;
            }
            case 1: {
                return this.currentItemMillTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemMillTime = value;
                break;
            }
            case 1: {
                this.currentItemMillTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        this.millItemStacks.clear();
    }

    public String func_70005_c_() {
        return "container.mill";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

