package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.util.Localization;

import javax.annotation.Nullable;

public class TileEntityChopper extends TileEntityHPHorseBase {

    private static final int[] SLOTS_TOP = new int[] {0};
    private static final int[] SLOTS_SIDE = new int[] {0};
    private static final int[] SLOTS_BOTTOM = new int[] {1};

    private int currentWindup;
    private int currentItemChopTime;
    private int totalItemChopTime;
    private float visualWindup = 0;
    private float oldVisualWindup = -1;

    public TileEntityChopper() {
        super(2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("currentWindup", currentWindup);
        compound.func_74768_a("chopTime", currentItemChopTime);
        compound.func_74768_a("totalChopTime", totalItemChopTime);

        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        currentWindup = compound.func_74762_e("currentWindup");

        if (func_70301_a(0).func_190916_E() > 0) {
            currentItemChopTime = compound.func_74762_e("chopTime");
            totalItemChopTime = compound.func_74762_e("totalChopTime");
        } else {
            currentItemChopTime = 0;
            totalItemChopTime = 1;
        }
    }

    @Override
    public void func_70296_d() {
        //if (getStackInSlot(1).isEmpty())
            //BlockGrindstone.setState(false, world, pos);

        super.func_70296_d();
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1 && index == 0 && HPRecipes.instance().hasChopperRecipe(stack) && func_70301_a(1).func_190926_b() && func_70301_a(0).func_190926_b();
    }

    @Override
    public boolean validateArea() {
        if (searchPos == null) {
            searchPos = Lists.newArrayList();

            for (int x = -3; x <= 3; x++) {
                for (int z = -3; z <= 3; z++) {
                    if (x == 0 && z == 0)
                        continue;
                    searchPos.add(func_174877_v().func_177982_a(x, 0, z));
                    searchPos.add(func_174877_v().func_177982_a(x, 1, z));
                }
            }
        }

        for (BlockPos pos: searchPos) {
            if (!func_145831_w().func_175623_d(pos))
                return false;
        }
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();

        float windup = Configs.pointsForWindup > 0 ? Configs.pointsForWindup: 1;
        visualWindup = -0.74F + (0.74F * (((float)currentWindup) / (windup - 1)));
    }

    @Override
    public boolean targetReached() {
        currentWindup++;

        if (currentWindup >= Configs.pointsForWindup) {
            currentWindup = 0;
            currentItemChopTime++;

            if (currentItemChopTime >= totalItemChopTime) {
                currentItemChopTime = 0;

                totalItemChopTime = HPRecipes.instance().getChoppingTime(func_70301_a(0));
                chopItem();
                return true;
            }
        }
        func_70296_d();
        return false;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = func_70301_a(index);
        super.func_70299_a(index, stack);

        if (index == 1 && func_70301_a(1).func_190926_b()) {
            func_70296_d();
        }

        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a(stack, itemstack);
        if (index == 0 && !flag) {
            totalItemChopTime = HPRecipes.instance().getChoppingTime(stack);
            currentItemChopTime = 0;
            currentWindup = 0;
            func_70296_d();
        }
    }

    private void chopItem() {
        if (canWork()) {
            ItemStack input = func_70301_a(0);
            ItemStack result = getRecipeItemStack();
            ItemStack output = func_70301_a(1);

            if (output.func_190926_b()) {
                func_70299_a(1, result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }

            input.func_190918_g(1);
            func_70296_d();
        }
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getChopperResult(func_70301_a(0));
    }

    @Override
    public int getPositionOffset() {
        return 0;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDE);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0:
                return totalItemChopTime;
            case 1:
                return currentItemChopTime;
            case 2:
                return currentWindup;
            default:
                return 0;
        }
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0:
                totalItemChopTime = value;
                break;
            case 1:
                currentItemChopTime = value;
            case 2:
                currentWindup = value;
        }
    }

    @Override
    public int func_174890_g() {
        return 3;
    }

    @Override
    public String func_70005_c_() {
        return "container.chopper";
    }

    public float getVisualWindup() {
        return visualWindup;
    }

    public float getOldVisualWindup() {
        return oldVisualWindup;
    }

    @Nullable
    @Override
    public ITextComponent func_145748_c_() {
        if (valid)
            return super.func_145748_c_();
        else
            return new TextComponentTranslation(Localization.INFO.CHOPPING_INVALID.key()).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }
}
