/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GGRConfig
extends Configuration {
    public static final String CATEGORY_GAMERULES = "gamerules";
    public static final String CATEGORY_MISC = "misc";
    public static final String MISC_WORLDDIFFICULTY = "worldDifficulty";
    public static final String MISC_WORLDDIFFICULTYLOCK = "worldDifficultyLocked";
    public static final String MISC_SAVEGAMRULES = "saveGameRules";
    public HashMap<String, Value> rules = new HashMap();
    public HashMap<String, Value> misc = new HashMap();
    public HashMap<String, Value> defaults;
    public HashMap<String, String> comments = new HashMap();

    public GGRConfig(File name) {
        super(name);
        this.rules.put("commandBlockOutput", this.defaultValue(true));
        this.rules.put("disableElytraMovementCheck", this.defaultValue(false));
        this.rules.put("doDaylightCycle", this.defaultValue(true));
        this.rules.put("doEntityDrops", this.defaultValue(true));
        this.rules.put("doFireTick", this.defaultValue(true));
        this.rules.put("doLimitedCrafting", this.defaultValue(false));
        this.rules.put("doMobLoot", this.defaultValue(true));
        this.rules.put("doMobSpawning", this.defaultValue(true));
        this.rules.put("doTileDrops", this.defaultValue(true));
        this.rules.put("doWeatherCycle", this.defaultValue(true));
        this.rules.put("gameLoopFunction", this.defaultValue("-"));
        this.rules.put("keepInventory", this.defaultValue(false));
        this.rules.put("logAdminCommands", this.defaultValue(true));
        this.rules.put("maxCommandChainLength", this.defaultValue(65536));
        this.rules.put("maxEntityCramming", this.defaultValue(24));
        this.rules.put("mobGriefing", this.defaultValue(true));
        this.rules.put("naturalRegeneration", this.defaultValue(true));
        this.rules.put("randomTickSpeed", this.defaultValue(3));
        this.rules.put("reducedDebugInfo", this.defaultValue(false));
        this.rules.put("sendCommandFeedback", this.defaultValue(true));
        this.rules.put("showDeathMessages", this.defaultValue(true));
        this.rules.put("spawnRadius", this.defaultValue(10));
        this.rules.put("spectatorsGenerateChunks", this.defaultValue(true));
        this.rules.put("announceAdvancements", this.defaultValue(true));
        this.misc.put(MISC_WORLDDIFFICULTY, this.defaultValue(-1));
        this.misc.put(MISC_WORLDDIFFICULTYLOCK, this.defaultValue(false));
        this.misc.put(MISC_SAVEGAMRULES, new Value("true", ValueType.BOOLEAN, true, false));
        this.comments.put("commandBlockOutput", "Whether command blocks should notify admins when they perform commands");
        this.comments.put("disableElytraMovementCheck", "Whether the server should skip checking player speed when the player is wearing elytra.");
        this.comments.put("doDaylightCycle", "Whether the day-night cycle and moon phases progress");
        this.comments.put("doEntityDrops", "Whether entities that are not mobs should have drops");
        this.comments.put("doFireTick", "Whether fire should spread and naturally extinguish");
        this.comments.put("doLimitedCrafting", "Whether players should only be able to craft recipes that they've unlocked first");
        this.comments.put("doMobLoot", "Whether mobs should drop items");
        this.comments.put("doMobSpawning", "Whether mobs should naturally spawn");
        this.comments.put("doTileDrops", "Whether blocks should have drops");
        this.comments.put("doWeatherCycle", "Whether the weather will change");
        this.comments.put("gameLoopFunction", "The function to run every game tick");
        this.comments.put("keepInventory", "Whether the player should keep items in their inventory after death");
        this.comments.put("logAdminCommands", "Whether to log admin commands to server log");
        this.comments.put("maxCommandChainLength", "Determines the number at which the chain command block acts as a \"chain\".");
        this.comments.put("maxEntityCramming", "The maximum number of other pushable entities a mob or player can push, before taking 3 suffocation damage\nper half-second. Setting to 0 disables the rule. Damage affects survival-mode or adventure-mode players, and all mobs but bats.\nPushable entities include non-spectator-mode players, any mob except bats, as well as boats and minecarts.");
        this.comments.put("mobGriefing", "Whether creepers, zombies, endermen, ghasts, withers, ender dragons, rabbits, sheep, and villagers should be able to change blocks\nand whether villagers, zombies, skeletons, and zombie pigmen can pick up items");
        this.comments.put("naturalRegeneration", "Whether the player can regenerate health naturally if their hunger is full enough (doesn't affect external healing, such as\ngolden apples, the Regeneration effect, etc.)");
        this.comments.put("randomTickSpeed", "How often a random block tick occurs (such as plant growth, leaf decay, etc.) per chunk section per game tick. 0 will disable random\nticks, higher numbers will increase random ticks");
        this.comments.put("reducedDebugInfo", "Whether the debug screen shows all or reduced information; and whether the effects of F3+B (entity hitboxes) and F3+G (chunk boundaries) are shown.");
        this.comments.put("sendCommandFeedback", "Whether the feedback from commands executed by a player should show up in chat. Also affects the default behavior of whether command blocks store their output text");
        this.comments.put("showDeathMessages", "Whether a message appears in chat when a player dies");
        this.comments.put("spawnRadius", "The number of blocks outward from the world spawn coordinates that a player will spawn in when first joining a server or when dying without a spawnpoint.");
        this.comments.put("spectatorsGenerateChunks", "Whether players in spectator mode can generate chunks");
        this.comments.put("announceAdvancements", "If an announcement when a player gets an advancement should be done");
        this.comments.put(MISC_WORLDDIFFICULTY, "Sets the difficulty of a world when loaded, respects it the difficulty is locked or not for the world\n-1: Disabled\n0: Peaceful\n1: Easy\n2: Normal\n3: Hard");
        this.comments.put(MISC_WORLDDIFFICULTYLOCK, "If a world's difficulty should be locked when loaded, if world already is locked it can't be change\nIf the global world difficulty is enabled it's set first");
        this.comments.put(MISC_SAVEGAMRULES, "If gamerules and world difficulty should be saved to config on world unload");
        this.addCustomCategoryComment(CATEGORY_GAMERULES, "Set the values to ('true'/'false'/an integer or a string defaultValue) depending if you want to have the GameRule (enabled/disabled or have a different defaultValue)");
        this.addCustomCategoryComment(CATEGORY_MISC, "A collection of misc configs");
        this.defaults = (HashMap)this.rules.clone();
        this.defaults.putAll((Map)this.misc.clone());
    }

    private Value defaultValue(boolean val) {
        return new Value(Boolean.toString(val), ValueType.BOOLEAN);
    }

    private Value defaultValue(int val) {
        return new Value(Integer.toString(val), ValueType.INTEGER);
    }

    private Value defaultValue(String val) {
        return new Value(val, ValueType.STRING);
    }

    public GGRConfig loadConfig() {
        this.load();
        this.syncConfigs();
        this.saveConfig();
        this.save();
        return this;
    }

    public void saveConfig() {
        ConfigCategory ruleCat = this.getCategory(CATEGORY_GAMERULES);
        this.setValueToProp(ruleCat, this.rules);
        ConfigCategory miscCat = this.getCategory(CATEGORY_MISC);
        this.setValueToProp(miscCat, this.misc);
        if (this.hasChanged()) {
            this.save();
        }
    }

    private void setValueToProp(ConfigCategory cat, HashMap<String, Value> list) {
        list.forEach((s, value) -> {
            if (cat.containsKey(s)) {
                cat.put(s, value.getType().equals((Object)ValueType.BOOLEAN) ? cat.get(s).setValue(value.getBooleanValue()).setRequiresWorldRestart(value.getRequireWorldRestart()).setShowInGui(value.getShowInGui()) : (value.getType().equals((Object)ValueType.INTEGER) ? cat.get(s).setValue(value.getIntegerValue()).setRequiresWorldRestart(value.getRequireWorldRestart()).setShowInGui(value.getShowInGui()) : cat.get(s).setValue(value.getStringValue()).setRequiresWorldRestart(value.getRequireWorldRestart()).setShowInGui(value.getShowInGui())));
            } else {
                this.get(cat.getQualifiedName(), (String)s, value.getStringValue(), "GameRule added by another mod or from commands").setRequiresWorldRestart(value.getRequireWorldRestart()).setShowInGui(value.getShowInGui());
            }
        });
    }

    public void syncConfigs() {
        this.syncConfigs(this.getCategory(CATEGORY_GAMERULES).getValues(), this.rules, CATEGORY_GAMERULES);
        this.syncConfigs(this.getCategory(CATEGORY_MISC).getValues(), this.misc, CATEGORY_MISC);
        if (this.hasChanged()) {
            this.save();
        }
    }

    private void syncConfigs(Map<String, Property> values, HashMap<String, Value> list, String cat) {
        values.forEach((s, value) -> list.put((String)s, new Value(value.getType().equals((Object)Property.Type.BOOLEAN) ? String.valueOf(this.get(cat, (String)s, this.defaults.get(s).getBooleanValue(), this.getComment((String)s)).getBoolean()) : (value.getType().equals((Object)Property.Type.INTEGER) ? String.valueOf(this.get(cat, (String)s, this.defaults.get(s).getIntegerValue(), this.getComment((String)s)).getInt()) : this.get(cat, (String)s, this.defaults.get(s) != null ? this.defaults.get(s).getStringValue() : value.getString(), this.getComment((String)s)).getString()), value.getType().equals((Object)Property.Type.BOOLEAN) ? ValueType.BOOLEAN : (value.getType().equals((Object)Property.Type.INTEGER) ? ValueType.INTEGER : ValueType.STRING), list.get(s) != null ? ((Value)list.get(s)).getShowInGui() : value.showInGui(), list.get(s) != null ? ((Value)list.get(s)).getRequireWorldRestart() : CATEGORY_GAMERULES.equals(cat) || value.requiresWorldRestart())));
    }

    private String getComment(String s) {
        return this.comments.get(s) != null ? this.comments.get(s) : "GameRule added by another mod or from commands";
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("globalgamerules")) {
            this.syncConfigs();
        }
    }

    public static class Value
    implements Cloneable {
        private String stringValue;
        private int integerValue;
        private boolean booleanValue;
        private boolean showInGui;
        private boolean requireWorldRestart;
        private ValueType type;

        public Value(String s, ValueType type) {
            this(s, type, true);
        }

        public Value(String s, ValueType type, boolean showInGui) {
            this(s, type, showInGui, true);
        }

        public Value(String s, ValueType type, boolean showInGui, boolean requireWorldRestart) {
            this.type = type;
            this.showInGui = showInGui;
            this.requireWorldRestart = requireWorldRestart;
            this.setValue(s);
        }

        public Value setValue(String s) {
            this.stringValue = s;
            this.booleanValue = Boolean.parseBoolean(s);
            this.integerValue = this.booleanValue ? 1 : 0;
            try {
                this.integerValue = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return this;
        }

        public int getIntegerValue() {
            return this.integerValue;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public boolean getShowInGui() {
            return this.showInGui;
        }

        public boolean getRequireWorldRestart() {
            return this.requireWorldRestart;
        }

        public ValueType getType() {
            return this.type;
        }

        protected Value clone() throws CloneNotSupportedException {
            return (Value)super.clone();
        }
    }

    public static enum ValueType {
        BOOLEAN,
        INTEGER,
        STRING;

    }
}

