package se.gory_moon.chargers.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.blocks.BlockCharger;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TileEntityCharger extends TileEntity implements ITickable {

    public CustomEnergyStorage storage;
    public final ItemStackHandler inventoryHandler;
    public BlockCharger.Tier tier;
    private int lastEnergy;
    private int diff;

    public TileEntityCharger(BlockCharger.Tier tier) {
        this();
        setTier(tier);
    }

    public TileEntityCharger() {
        super();
        inventoryHandler = new CustomItemStackHandler(2);
    }

    private void setTier(BlockCharger.Tier tier) {
        this.tier = tier;
        int storageAmount = tier == BlockCharger.Tier.I ? Configs.chargers.tier1.storage: tier == BlockCharger.Tier.II ? Configs.chargers.tier2.storage: Configs.chargers.tier3.storage;
        int maxIn = tier == BlockCharger.Tier.I ? Configs.chargers.tier1.maxInput: tier == BlockCharger.Tier.II ? Configs.chargers.tier2.maxInput: Configs.chargers.tier3.maxInput;
        int maxOut = tier == BlockCharger.Tier.I ? Configs.chargers.tier1.maxOutput: tier == BlockCharger.Tier.II ? Configs.chargers.tier2.maxOutput: Configs.chargers.tier3.maxOutput;
        storage = new CustomEnergyStorage(storageAmount, maxIn, maxOut);
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !oldState.func_177230_c().func_149667_c(newSate.func_177230_c());
    }

    @Override
    public void func_73660_a() {
        if (!func_145831_w().field_72995_K) {
            ItemStack input = inventoryHandler.getStackInSlot(0);
            ItemStack output = inventoryHandler.getStackInSlot(1);
            if (!input.func_190926_b() && output.func_190926_b() && storage.getEnergyStored() > 0) {
                if (input.hasCapability(CapabilityEnergy.ENERGY, null)) {
                    IEnergyStorage energyStorage = input.getCapability(CapabilityEnergy.ENERGY, null);
                    if (energyStorage != null && input.func_190916_E() == 1) {
                        int transferred = energyStorage.receiveEnergy(storage.extractEnergy(storage.getEnergyStored(), true), false);
                        if (transferred > 0) {
                            storage.extractEnergy(transferred, false);
                        }
                        if (energyStorage.getEnergyStored() >= energyStorage.getMaxEnergyStored()) {
                            inventoryHandler.setStackInSlot(1, input.func_77946_l());
                            input.func_190918_g(1);
                            inventoryHandler.setStackInSlot(0, input.func_190916_E() <= 0 ? ItemStack.field_190927_a: input);
                        }
                    }
                }
            }

            setEnergyDiff(storage.getEnergyStored() - lastEnergy);
            if (lastEnergy != storage.getEnergyStored()) {
                lastEnergy = storage.getEnergyStored();
            }
        }
    }

    public void setEnergyDiff(int diff) {
        this.diff = diff;
    }

    public int getEnergyDiff() {
        return diff;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        inventoryHandler.deserializeNBT(compound.func_74775_l("Inventory"));
        setTier(BlockCharger.Tier.byMetadata(compound.func_74762_e("Tier")));
        storage.readFromNBT(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("Inventory", inventoryHandler.serializeNBT());
        compound.func_74768_a("Tier", tier.getMeta());
        compound = storage.writeToNBT(compound);
        return compound;
    }

    @Nullable
    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, func_189517_E_());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return func_189515_b(new NBTTagCompound());
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        func_145839_a(tag);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @SuppressWarnings("unchecked")
    @Nullable
    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY)
            return (T) storage;
        else if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
            return (T) inventoryHandler;
        else
            return super.getCapability(capability, facing);
    }
}
